/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.dso;

import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AfterHandler
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AfterHandler.class);

    public void doFilter(Context ctx, FilterChain chain) throws Throwable {
        chain.doFilter(ctx);
        Long time_start = (Long)ctx.attr("time_start");
        StringBuilder buf = new StringBuilder();
        buf.append("> Header: ").append(ctx.headerMap()).append("\n");
        buf.append("> Param: ").append(ctx.paramMap()).append("\n");
        buf.append("> Body: ").append(ctx.body()).append("\n");
        if (time_start != null) {
            buf.append("T Elapsed time: ").append(System.currentTimeMillis() - time_start).append("ms").append("\n");
        }
        buf.append("\n");
        MDC.put((String)"tag0", (String)"gritapi");
        MDC.put((String)"tag1", (String)ctx.path());
        if (ctx.errors == null) {
            buf.append("< Body: ").append(ONode.stringify((Object)ctx.result));
            log.info("{}", (Object)buf);
        } else {
            buf.append("< Error: ").append(Utils.throwableToString((Throwable)ctx.errors));
            log.error("{}", (Object)buf);
        }
    }
}

