/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.dso.service.impl;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.noear.grit.client.GritUtil;
import org.noear.grit.model.data.SubjectDo;
import org.noear.grit.model.domain.Subject;
import org.noear.grit.model.domain.SubjectEntity;
import org.noear.grit.model.domain.SubjectGroup;
import org.noear.grit.model.type.SubjectType;
import org.noear.grit.server.dso.service.SubjectAdminService;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.ProxyComponent;
import org.noear.solon.data.annotation.Tran;
import org.noear.wood.DbContext;
import org.noear.wood.DbTableQuery;
import org.noear.wood.cache.ICacheService;

@ProxyComponent
public class SubjectAdminServiceImpl
implements SubjectAdminService {
    @Inject(value="grit.db")
    private DbContext db;
    @Inject(value="grit.cache")
    private ICacheService cache;

    @Override
    public long addSubject(SubjectDo subject) throws SQLException {
        if (subject.subject_type == SubjectType.entity.code) {
            subject.subject_pid = -1L;
        }
        if (Utils.isEmpty((String)subject.login_name)) {
            subject.login_name = Utils.guid();
        }
        subject.login_password = Utils.isNotEmpty((String)subject.login_password) ? GritUtil.buildPassword((String)subject.login_name, (String)subject.login_password) : null;
        subject.gmt_modified = subject.gmt_create = Long.valueOf(System.currentTimeMillis());
        if (Utils.isEmpty((String)subject.guid)) {
            subject.guid = Utils.guid();
        }
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_subject").setEntity((Object)subject).usingNull(false)).usingExpr(false)).insert();
    }

    @Override
    public long addSubjectEntity(SubjectDo subject, long subjectGroupId) throws SQLException {
        long subjectEntityId = this.addSubject(subject);
        if (subjectGroupId > 0L) {
            this.addSubjectLink(subjectEntityId, subjectGroupId);
        }
        return subjectEntityId;
    }

    @Override
    public boolean updSubjectById(long subjectId, SubjectDo subject) throws SQLException {
        if (subject.subject_type == SubjectType.entity.code) {
            subject.subject_pid = -1L;
        }
        if (Utils.isEmpty((String)subject.login_name)) {
            subject.login_name = Utils.guid();
        }
        subject.login_password = Utils.isNotEmpty((String)subject.login_password) ? GritUtil.buildPassword((String)subject.login_name, (String)subject.login_password) : null;
        subject.gmt_modified = System.currentTimeMillis();
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_subject").setEntity((Object)subject).usingNull(false)).usingExpr(false)).whereEq("subject_id", (Object)subjectId)).update() > 0;
    }

    @Override
    @Tran
    public boolean delSubjectById(long subjectId) throws SQLException {
        boolean isOk = ((DbTableQuery)this.db.table("grit_subject").whereEq("subject_id", (Object)subjectId)).delete() > 0;
        ((DbTableQuery)((DbTableQuery)this.db.table("grit_subject_linked").whereEq("subject_id", (Object)subjectId)).orEq("group_subject_id", (Object)subjectId)).delete();
        ((DbTableQuery)this.db.table("grit_resource_linked").whereEq("subject_id", (Object)subjectId)).delete();
        return isOk;
    }

    @Override
    public Subject getSubjectById(long subjectId) throws SQLException {
        if (subjectId < 1L) {
            return new Subject();
        }
        return (Subject)((DbTableQuery)this.db.table("grit_subject").whereEq("subject_id", (Object)subjectId)).selectItem("*", Subject.class);
    }

    @Override
    public Subject getSubjectByGuid(String guid) throws SQLException {
        if (Utils.isEmpty((String)guid)) {
            return new Subject();
        }
        return (Subject)((DbTableQuery)this.db.table("grit_subject").whereEq("guid", (Object)guid)).selectItem("*", Subject.class);
    }

    @Override
    public List<SubjectGroup> getGroupList() throws SQLException {
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_subject").whereEq("subject_type", (Object)SubjectType.group.code)).limit(200)).selectList("*", SubjectGroup.class);
    }

    @Override
    public List<SubjectEntity> getSubjectEntityListByAll() throws SQLException {
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_subject").whereEq("subject_type", (Object)SubjectType.entity.code)).limit(200)).selectList("*", SubjectEntity.class);
    }

    @Override
    public List<SubjectEntity> getSubjectEntityListByFind(String key) throws SQLException {
        String likeKey = "%" + key + "%";
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_subject").whereEq("subject_type", (Object)SubjectType.entity.code)).and("(login_name LIKE ? OR display_name LIKE ?)", new Object[]{likeKey, likeKey})).limit(200)).selectList("*", SubjectEntity.class);
    }

    @Override
    public List<SubjectEntity> getSubjectEntityListByGroup(long subjectGroupId) throws SQLException {
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_subject_linked l").innerJoin("grit_subject s")).on("l.subject_id=s.subject_id")).andEq("l.group_subject_id", (Object)subjectGroupId)).selectList("*", SubjectEntity.class);
    }

    @Override
    public List<Long> getSubjectGroupIdListByEntity(long subjectId) throws SQLException {
        return ((DbTableQuery)this.db.table("grit_subject_linked").whereEq("subject_id", (Object)subjectId)).selectArray("group_subject_id");
    }

    @Override
    public long addSubjectLink(long subjectId, long subjectGroupId) throws SQLException {
        return this.db.table("grit_subject_linked").set("subject_id", (Object)subjectId).set("group_subject_id", (Object)subjectGroupId).set("gmt_create", (Object)System.currentTimeMillis()).insert();
    }

    @Override
    public boolean hasSubjectLink(long subjectId, long subjectGroupId) throws SQLException {
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_subject_linked").whereEq("subject_id", (Object)subjectId)).andEq("group_subject_id", (Object)subjectGroupId)).selectExists();
    }

    @Override
    public boolean delSubjectLinkBySubjects(Collection<Long> subjectIds, long subjectGroupId) throws SQLException {
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_subject_linked").whereIn("subject_id", subjectIds)).andEq("group_subject_id", (Object)subjectGroupId)).delete() > 0;
    }
}

