/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.controller;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.noear.grit.client.GritClient;
import org.noear.grit.client.comparator.ResourceComparator;
import org.noear.grit.model.domain.Resource;
import org.noear.grit.model.domain.ResourceEntity;
import org.noear.grit.model.domain.ResourceGroup;
import org.noear.grit.model.domain.ResourceSpace;
import org.noear.grit.model.domain.Subject;
import org.noear.grit.model.domain.SubjectGroup;
import org.noear.grit.server.dso.AfterHandler;
import org.noear.grit.server.dso.BeforeHandler;
import org.noear.grit.service.AuthService;
import org.noear.okldap.LdapClient;
import org.noear.okldap.LdapSession;
import org.noear.okldap.entity.LdapPerson;
import org.noear.solon.annotation.After;
import org.noear.solon.annotation.Before;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Remoting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Before(value={BeforeHandler.class})
@After(value={AfterHandler.class})
@Mapping(value="/grit/api/v1/AuthService")
@Remoting
public class AuthServiceImpl
implements AuthService {
    static Logger log = LoggerFactory.getLogger(AuthServiceImpl.class);
    @Inject(required=false)
    LdapClient ldapClient;

    public Subject login(String loginName, String loginPassword) throws Exception {
        if (loginPassword == null || loginPassword.length() < 4) {
            log.warn("Warn ... loginPassword == null || loginPassword.length() < 4");
            return new Subject();
        }
        if (this.ldapClient != null) {
            log.info("Using ldap account ...");
            LdapPerson person = null;
            try (LdapSession session = this.ldapClient.open();){
                person = session.findPersonOne(loginName, loginPassword);
            }
            if (person != null) {
                log.info("Found ldap account : " + loginName);
                Subject subject = GritClient.global().subject().getSubjectByLoginName(loginName);
                if (subject.subject_id == null || subject.subject_id == 0L) {
                    subject.subject_id = GritClient.global().subject().regSubject(loginName, loginPassword, person.getDisplayName());
                    subject.login_name = loginName;
                    subject.display_name = person.getDisplayName();
                }
                return subject;
            }
            return new Subject();
        }
        log.info("Using grit account ...");
        return GritClient.global().subject().getSubjectByLoginNameAndPassword(loginName, loginPassword);
    }

    public boolean hasUriBySpace(long subjectId, long resourceSpaceId, String uri) throws SQLException {
        if (subjectId < 1L) {
            return false;
        }
        Resource resource = GritClient.global().resource().getResourceByUriAndSpace(resourceSpaceId, uri);
        if (resource.resource_id == null) {
            return false;
        }
        List<Long> subjectIds = this.getSubjectIdsByEntityOnAuth(subjectId);
        return GritClient.global().resourceLink().hasResourceLinkBySubjects(resource.resource_id.longValue(), subjectIds);
    }

    public boolean hasPermissionBySpace(long subjectId, long resourceSpaceId, String permission) throws SQLException {
        if (subjectId < 1L) {
            return false;
        }
        Resource resource = GritClient.global().resource().getResourceByCodeAndSpace(resourceSpaceId, permission);
        if (resource.resource_id == null) {
            return false;
        }
        List<Long> subjectIds = this.getSubjectIdsByEntityOnAuth(subjectId);
        return GritClient.global().resourceLink().hasResourceLinkBySubjects(resource.resource_id.longValue(), subjectIds);
    }

    public boolean hasRole(long subjectId, String role) throws SQLException {
        Subject subjectGroup = GritClient.global().subject().getSubjectByCode(role);
        return GritClient.global().subjectLink().hasSubjectLink(subjectId, subjectGroup.subject_id.longValue());
    }

    public List<ResourceEntity> getResListByGroup(long subjectId, long resourceGroupId) throws SQLException {
        List<Long> subjectIds = this.getSubjectIdsByEntityOnAuth(subjectId);
        return GritClient.global().resourceLink().getResourceEntityListBySubjectsAndGroup(subjectIds, resourceGroupId, null);
    }

    public List<ResourceEntity> getResListByGroupCode(long subjectId, String resourceGroupCode) throws SQLException {
        Resource group = GritClient.global().resource().getResourceByCode(resourceGroupCode);
        if (group.resource_id == null) {
            return new ArrayList<ResourceEntity>();
        }
        return this.getResListByGroup(subjectId, group.resource_id);
    }

    public List<ResourceEntity> getUriListByGroup(long subjectId, long resourceGroupId) throws SQLException {
        List<Long> subjectIds = this.getSubjectIdsByEntityOnAuth(subjectId);
        List list = GritClient.global().resourceLink().getResourceEntityListBySubjectsAndGroup(subjectIds, resourceGroupId, Boolean.valueOf(true));
        list.sort(ResourceComparator.instance);
        return list;
    }

    public List<ResourceEntity> getUriListBySpace(long subjectId, long resourceSpaceId) throws SQLException {
        List<Long> subjectIds = this.getSubjectIdsByEntityOnAuth(subjectId);
        return GritClient.global().resourceLink().getResourceEntityListBySubjectsAndSpace(subjectIds, resourceSpaceId, Boolean.valueOf(true));
    }

    public ResourceEntity getUriFristBySpace(long subjectId, long resourceSpaceId) throws SQLException {
        List<Long> subjectIds = this.getSubjectIdsByEntityOnAuth(subjectId);
        return GritClient.global().resourceLink().getResourceEntityFristBySubjectsAndSpace(subjectIds, resourceSpaceId, Boolean.valueOf(true));
    }

    public ResourceEntity getUriFristByGroup(long subjectId, long resourceGroupId) throws SQLException {
        List<Long> subjectIds = this.getSubjectIdsByEntityOnAuth(subjectId);
        return GritClient.global().resourceLink().getResourceEntityFristBySubjectsAndGroup(subjectIds, resourceGroupId, Boolean.valueOf(true));
    }

    public List<ResourceGroup> getUriGroupListBySpace(long subjectId, long resourceSpaceId) throws SQLException {
        List<Long> subjectIds = this.getSubjectIdsByEntityOnAuth(subjectId);
        List list = GritClient.global().resourceLink().getResourceGroupListBySubjects(subjectIds, resourceSpaceId, Boolean.valueOf(true));
        list.sort(ResourceComparator.instance);
        return list;
    }

    public List<ResourceEntity> getPermissionListBySpace(long subjectId, long resourceSpaceId) throws SQLException {
        List<Long> subjectIds = this.getSubjectIdsByEntityOnAuth(subjectId);
        return GritClient.global().resourceLink().getResourceEntityListBySubjectsAndSpace(subjectIds, resourceSpaceId, Boolean.valueOf(false));
    }

    public List<SubjectGroup> getRoleList(long subjectId) throws SQLException {
        return GritClient.global().subjectLink().getSubjectGroupListByEntity(subjectId);
    }

    public List<ResourceSpace> getSpaceList(long subjectId) throws SQLException {
        List<Long> subjectIds = this.getSubjectIdsByEntityOnAuth(subjectId);
        List list = GritClient.global().resourceLink().getResourceSpaceListBySubjects(subjectIds, Boolean.valueOf(true));
        list.sort(ResourceComparator.instance);
        return list;
    }

    public ResourceSpace getSpaceFrist(long subjectId) throws SQLException {
        List<ResourceSpace> branchList = this.getSpaceList(subjectId);
        if (branchList.size() == 0) {
            return new ResourceSpace();
        }
        return branchList.get(0);
    }

    private List<Long> getSubjectIdsByEntityOnAuth(long subjectEntityId) throws SQLException {
        List subjectIds = GritClient.global().subjectLink().getSubjectGroupIdListByEntity(subjectEntityId);
        subjectIds.add(subjectEntityId);
        return subjectIds;
    }
}

