/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.dso.service.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.noear.grit.model.data.ResourceDo;
import org.noear.grit.model.data.ResourceLinkedDo;
import org.noear.grit.model.domain.Resource;
import org.noear.grit.model.domain.ResourceEntity;
import org.noear.grit.model.domain.ResourceGroup;
import org.noear.grit.model.domain.ResourceSpace;
import org.noear.grit.model.type.ResourceType;
import org.noear.grit.server.dso.service.ResourceAdminService;
import org.noear.grit.server.dso.service.SubjectAdminService;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.ProxyComponent;
import org.noear.solon.data.annotation.Tran;
import org.noear.wood.DataItem;
import org.noear.wood.DbContext;
import org.noear.wood.DbTableQuery;
import org.noear.wood.cache.ICacheService;

@ProxyComponent
public class ResourceAdminServiceImpl
implements ResourceAdminService {
    @Inject(value="grit.db")
    private DbContext db;
    @Inject(value="grit.cache")
    private ICacheService cache;
    @Inject
    SubjectAdminService subjectAdminService;

    @Override
    public long addResource(ResourceDo resource) throws SQLException {
        if (resource == null) {
            return -1L;
        }
        if (resource.gmt_create == null) {
            resource.gmt_create = System.currentTimeMillis();
        }
        if (resource.gmt_modified == null) {
            resource.gmt_modified = resource.gmt_create;
        }
        if (Utils.isEmpty((String)resource.guid)) {
            resource.guid = Utils.guid();
        }
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").setEntity((Object)resource).usingNull(false)).usingExpr(false)).insert();
    }

    @Override
    public boolean synResourceByGuid(ResourceDo resource) throws SQLException {
        if (resource == null || Utils.isEmpty((String)resource.guid)) {
            return false;
        }
        long tmp = (Long)((DbTableQuery)this.db.table("grit_resource").whereEq("guid", (Object)resource.guid)).selectValue("resource_id", (Object)0L);
        if (tmp > 0L) {
            resource.resource_id = tmp;
            ((DbTableQuery)this.db.table("grit_resource").set("resource_pid", (Object)resource.resource_pid).set("resource_sid", (Object)resource.resource_sid).whereEq("resource_id", (Object)tmp)).update();
        } else {
            resource.resource_id = null;
            resource.resource_id = this.addResource(resource);
        }
        return true;
    }

    @Override
    public boolean updResourceById(long resourceId, ResourceDo resource) throws SQLException {
        if (resource == null) {
            return false;
        }
        if (resourceId == 0L) {
            return false;
        }
        resource.gmt_modified = System.currentTimeMillis();
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").setEntity((Object)resource).usingNull(false)).usingExpr(false)).whereEq("resource_id", (Object)resourceId)).update() > 0;
    }

    @Override
    @Tran
    public boolean delResourceById(long resourceId) throws SQLException {
        if (resourceId == 0L) {
            return false;
        }
        boolean isOk = ((DbTableQuery)this.db.table("grit_resource").whereEq("resource_id", (Object)resourceId)).delete() > 0;
        ((DbTableQuery)this.db.table("grit_resource_linked").whereEq("resource_id", (Object)resourceId)).delete();
        return isOk;
    }

    @Override
    @Tran
    public boolean delResourceByIds(String ids) throws SQLException {
        if (Utils.isEmpty((String)ids)) {
            return false;
        }
        List<Object> idList = this.getIdList(ids);
        boolean isOk = ((DbTableQuery)this.db.table("grit_resource").whereIn("resource_id", idList)).delete() > 0;
        ((DbTableQuery)this.db.table("grit_resource_linked").whereIn("resource_id", idList)).delete();
        return isOk;
    }

    @Override
    @Tran
    public boolean desResourceByIds(String ids, boolean disabled) throws SQLException {
        if (Utils.isEmpty((String)ids)) {
            return false;
        }
        List<Object> idList = this.getIdList(ids);
        return ((DbTableQuery)this.db.table("grit_resource").set("is_disabled", (Object)disabled).whereIn("resource_id", idList)).update() > 0;
    }

    @Override
    public Resource getResourceById(long resourceId) throws SQLException {
        if (resourceId == 0L) {
            return new Resource();
        }
        return (Resource)((DbTableQuery)this.db.table("grit_resource").whereEq("resource_id", (Object)resourceId)).selectItem("*", Resource.class);
    }

    @Override
    public Resource getResourceByGuid(String guid) throws SQLException {
        if (Utils.isEmpty((String)guid)) {
            return new Resource();
        }
        return (Resource)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("guid", (Object)guid)).limit(1)).selectItem("*", Resource.class);
    }

    @Override
    public Resource getResourceByCode(String resourceCode) throws SQLException {
        if (Utils.isEmpty((String)resourceCode)) {
            return new Resource();
        }
        return (Resource)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("resource_code", (Object)resourceCode)).limit(1)).selectItem("*", Resource.class);
    }

    @Override
    public List<ResourceSpace> getSpaceList() throws SQLException {
        return ((DbTableQuery)this.db.table("grit_resource").whereEq("resource_type", (Object)ResourceType.space.code)).selectList("*", ResourceSpace.class);
    }

    @Override
    public List<Resource> getResourceListBySpace(long resourceId) throws SQLException {
        if (resourceId == 0L) {
            return new ArrayList<Resource>();
        }
        return ((DbTableQuery)this.db.table("grit_resource").whereEq("resource_sid", (Object)resourceId)).selectList("*", Resource.class);
    }

    @Override
    public List<ResourceGroup> getResourceGroupListBySpace(long resourceId) throws SQLException {
        if (resourceId == 0L) {
            return new ArrayList<ResourceGroup>();
        }
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("resource_sid", (Object)resourceId)).andEq("resource_type", (Object)ResourceType.group.code)).selectList("*", ResourceGroup.class);
    }

    @Override
    public List<ResourceGroup> getResourceGroupListBySpaceAndIds(long resourceId, String ids) throws SQLException {
        if (resourceId == 0L || Utils.isEmpty((String)ids)) {
            return new ArrayList<ResourceGroup>();
        }
        List<Object> idList = this.getIdList(ids);
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("resource_sid", (Object)resourceId)).andEq("resource_type", (Object)ResourceType.group.code)).andIn("resource_id", idList)).selectList("*", ResourceGroup.class);
    }

    @Override
    public List<ResourceEntity> getResourceEntityListBySpace(long resourceId) throws SQLException {
        if (resourceId == 0L) {
            return new ArrayList<ResourceEntity>();
        }
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("resource_sid", (Object)resourceId)).andEq("resource_type", (Object)ResourceType.entity.code)).selectList("*", ResourceEntity.class);
    }

    @Override
    public boolean hasSubResourceByPid(long resourceId) throws SQLException {
        if (resourceId == 0L) {
            return false;
        }
        return ((DbTableQuery)this.db.table("grit_resource").whereEq("resource_pid", (Object)resourceId)).selectExists();
    }

    @Override
    public List<Resource> getSubResourceListByPid(long resourceId) throws SQLException {
        if (resourceId == 0L) {
            return new ArrayList<Resource>();
        }
        return ((DbTableQuery)this.db.table("grit_resource").whereEq("resource_pid", (Object)resourceId)).selectList("*", Resource.class);
    }

    @Override
    public List<Resource> getSubResourceListByPidAndIds(long resourceId, String ids) throws SQLException {
        if (resourceId == 0L || Utils.isEmpty((String)ids)) {
            return new ArrayList<Resource>();
        }
        List<Object> idList = this.getIdList(ids);
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("resource_pid", (Object)resourceId)).andIn("resource_id", idList)).selectList("*", Resource.class);
    }

    @Override
    public long addResourceLink(long resourceId, long subjectId, int subjectType) throws SQLException {
        return this.db.table("grit_resource_linked").set("resource_id", (Object)resourceId).set("subject_id", (Object)subjectId).set("subject_type", (Object)subjectType).set("gmt_create", (Object)System.currentTimeMillis()).insert();
    }

    @Override
    public void delResourceLink(long ... linkIds) throws SQLException {
        ((DbTableQuery)this.db.table("grit_resource_linked").whereIn("link_id", Arrays.asList(new long[][]{linkIds}))).delete();
    }

    @Override
    public void addResourceLinkBySubject(long subjectId, int subjectType, List<Long> resourceIds) throws SQLException {
        ArrayList<DataItem> items = new ArrayList<DataItem>();
        long gmt_create = System.currentTimeMillis();
        for (Long resId : resourceIds) {
            DataItem item = new DataItem();
            item.set("resource_id", (Object)resId);
            item.set("subject_id", (Object)subjectId);
            item.set("subject_type", (Object)subjectType);
            item.set("gmt_create", (Object)gmt_create);
            items.add(item);
        }
        this.db.table("grit_resource_linked").insertList(items);
    }

    @Override
    public void delResourceLinkBySubjectBySpace(long subjectId, long resourceSpaceId) throws SQLException {
        ((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("l").from("grit_resource_linked l,grit_resource r")).whereEq("l.subject_id", (Object)subjectId)).and("l.resource_id=r.resource_id", new Object[0])).andEq("r.resource_sid", (Object)resourceSpaceId)).delete();
    }

    @Override
    public List<ResourceLinkedDo> getResourceLinkListBySubjectSlf(long subjectId) throws SQLException {
        return ((DbTableQuery)this.db.table("grit_resource_linked").whereEq("subject_id", (Object)subjectId)).selectList("*", ResourceLinkedDo.class);
    }

    @Override
    public List<ResourceLinkedDo> getResourceLinkListBySubjectAll(long subjectId) throws SQLException {
        List<Long> subjectIds = this.getSubjectIdsByEntityOnAuth(subjectId);
        return ((DbTableQuery)this.db.table("grit_resource_linked").whereIn("subject_id", subjectIds)).selectList("*", ResourceLinkedDo.class).stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ResourceLinkedDo>(Comparator.comparing(r -> r.resource_id))), ArrayList::new));
    }

    private List<Long> getSubjectIdsByEntityOnAuth(long subjectEntityId) throws SQLException {
        List<Long> subjectIds = this.subjectAdminService.getSubjectGroupIdListByEntity(subjectEntityId);
        subjectIds.add(subjectEntityId);
        return subjectIds;
    }

    private List<Object> getIdList(String ids) {
        return Arrays.asList(ids.split(",")).stream().map(s -> Long.parseLong(s)).collect(Collectors.toList());
    }
}

