/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.dso;

import java.util.List;
import org.noear.grit.model.data.ResourceDo;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;

public class ResourceSpaceCookie {
    private static final String COOKIE_KEY = "grit_log__space";

    public static <T extends ResourceDo> long build(long spaceId, List<T> tags) {
        if (spaceId == 0L) {
            spaceId = ResourceSpaceCookie.get();
        }
        if (spaceId > 0L) {
            long spaceId2 = spaceId;
            if (!tags.stream().anyMatch(m -> spaceId2 == m.resource_id)) {
                spaceId = 0L;
            }
        }
        if (spaceId == 0L && !tags.isEmpty()) {
            spaceId = ((ResourceDo)tags.get((int)0)).resource_id;
        }
        return spaceId;
    }

    public static long get() {
        String tmp = Context.current().cookie(COOKIE_KEY);
        if (Utils.isNotEmpty((String)tmp)) {
            return Long.parseLong(tmp);
        }
        return 0L;
    }

    public static void set(long space_id) {
        if (space_id == 0L) {
            return;
        }
        Context.current().cookieSet(COOKIE_KEY, String.valueOf(space_id));
    }
}

