/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.grpc.integration;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerServiceDefinition;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.extend.grpc.annotation.EnableGrpc;
import org.noear.solon.extend.grpc.annotation.GrpcClient;
import org.noear.solon.extend.grpc.annotation.GrpcService;
import org.noear.solon.extend.grpc.integration.GrpcClientBeanInjector;
import org.noear.solon.extend.grpc.integration.GrpcServiceBeanBuilder;
import org.noear.solon.extend.grpc.integration.GrpcSignalProps;

public class XPluginImp
implements Plugin {
    private static Signal _signal;
    Server server;
    Map<Class<?>, Object> serviceMap;
    Map<Class<?>, Object> clientMap;

    public static Signal signal() {
        return _signal;
    }

    public void start(AopContext context) {
        if (Solon.app().source().getAnnotation(EnableGrpc.class) == null) {
            return;
        }
        this.serviceMap = new HashMap();
        this.clientMap = new HashMap();
        context.beanBuilderAdd(GrpcService.class, (BeanBuilder)new GrpcServiceBeanBuilder(this.serviceMap));
        context.beanInjectorAdd(GrpcClient.class, (BeanInjector)new GrpcClientBeanInjector(this.clientMap));
        context.beanOnloaded(ctx -> {
            try {
                this.startForServer(Solon.app());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void startForServer(SolonApp app) throws Throwable {
        if (this.serviceMap.size() == 0) {
            return;
        }
        GrpcSignalProps props = new GrpcSignalProps(25000);
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        long time_start = System.currentTimeMillis();
        PrintUtil.info((Object)"Server:main: io.grpc.Server(grpc)");
        ServerBuilder serverBuilder = ServerBuilder.forPort((int)_port);
        this.serviceMap.forEach((k, v) -> {
            if (v instanceof BindableService) {
                serverBuilder.addService((BindableService)v);
            }
            if (v instanceof ServerServiceDefinition) {
                serverBuilder.addService((ServerServiceDefinition)v);
            }
        });
        this.server = serverBuilder.build().start();
        _signal = new SignalSim(_name, _port, "http", SignalType.HTTP);
        app.signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        PrintUtil.info((Object)("Connector:main: grpc: Started ServerConnector@{grpc://localhost:" + _port + "}"));
        PrintUtil.info((Object)("Server:main: grpc: Started @" + (time_end - time_start) + "ms"));
    }

    public void stop() throws Throwable {
        if (this.server != null) {
            this.server.shutdown();
            this.server = null;
        }
    }
}

