/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.solon.integration;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.prop.impl.BaseServerProps;

public class GrpcServerProps
extends BaseServerProps {
    public static final String SERVER_GRPC_NAME = "server.grpc.name";
    public static final String SERVER_GRPC_PORT = "server.grpc.port";
    public static final String SERVER_GRPC_HOST = "server.grpc.host";
    public static final String SERVER_GRPC_CORETHREADS = "server.socket.coreThreads";
    public static final String SERVER_GRPC_MAXTHREADS = "server.socket.maxThreads";
    public static final String SERVER_GRPC_IDLETIMEOUT = "server.socket.idleTimeout";

    public GrpcServerProps(int portBase) {
        this.name = Solon.cfg().get(SERVER_GRPC_NAME);
        this.port = Solon.cfg().getInt(SERVER_GRPC_PORT, 0);
        this.host = Solon.cfg().get(SERVER_GRPC_HOST);
        if (this.port < 1) {
            this.port = portBase + Solon.cfg().serverPort();
        }
        if (Utils.isEmpty((String)this.host)) {
            this.host = Solon.cfg().serverHost();
        }
        this.coreThreads = Solon.cfg().getInt(SERVER_GRPC_CORETHREADS, 0);
        this.maxThreads = Solon.cfg().getInt(SERVER_GRPC_MAXTHREADS, 0);
        this.idleTimeout = Solon.cfg().getLong(SERVER_GRPC_IDLETIMEOUT, 0L);
    }
}

