/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.solon.integration;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.core.LoadBalance;

public class GrpcChannelProxy
extends Channel {
    LoadBalance upstream;
    Map<String, Channel> channelMap;

    public GrpcChannelProxy(String group, String service) {
        this.upstream = Utils.isEmpty((String)group) ? LoadBalance.get((String)service) : LoadBalance.get((String)group, (String)service);
        if (this.upstream == null) {
            throw new IllegalStateException("No service upstream found: " + service);
        }
        this.channelMap = new HashMap<String, Channel>();
    }

    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        return this.getChannel().newCall(methodDescriptor, callOptions);
    }

    public String authority() {
        return this.getChannel().authority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getChannel() {
        String server = this.upstream.getServer();
        Channel real = this.channelMap.get(server);
        if (real == null) {
            String string = server.intern();
            synchronized (string) {
                real = this.channelMap.get(server);
                if (real == null) {
                    URI uri = URI.create(server);
                    real = ManagedChannelBuilder.forAddress((String)uri.getHost(), (int)uri.getPort()).usePlaintext().build();
                    this.channelMap.put(server, real);
                }
            }
        }
        return real;
    }
}

