/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.solon.integration;

import io.grpc.Channel;
import io.grpc.solon.annotation.GrpcClient;
import io.grpc.solon.integration.GrpcChannelProxy;
import io.grpc.stub.AbstractBlockingStub;
import io.grpc.stub.AbstractFutureStub;
import java.lang.reflect.Method;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.util.ClassUtil;

public class GrpcClientBeanInjector
implements BeanInjector<GrpcClient> {
    Map<Class<?>, Object> clientMap;

    public GrpcClientBeanInjector(Map<Class<?>, Object> clientMap) {
        this.clientMap = clientMap;
    }

    public void doInject(VarHolder varH, GrpcClient anno) {
        Object grpcCli = this.clientMap.get(varH.getType());
        String name = Utils.annoAlias((String)anno.value(), (String)anno.name());
        if (grpcCli != null) {
            varH.setValue(grpcCli);
        } else {
            GrpcChannelProxy grpcChannel = new GrpcChannelProxy(anno.group(), name);
            Class grpcClz = ClassUtil.loadClass((String)varH.getType().getName().split("\\$")[0]);
            try {
                Method method;
                if (AbstractBlockingStub.class.isAssignableFrom(varH.getType())) {
                    method = grpcClz.getDeclaredMethod("newBlockingStub", Channel.class);
                    grpcCli = method.invoke(null, new Object[]{grpcChannel});
                }
                if (AbstractFutureStub.class.isAssignableFrom(varH.getType())) {
                    method = grpcClz.getDeclaredMethod("newFutureStub", Channel.class);
                    grpcCli = method.invoke(null, new Object[]{grpcChannel});
                }
                if (grpcCli != null) {
                    this.clientMap.put(varH.getType(), grpcCli);
                    varH.setValue(grpcCli);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}

