/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.solon.integration;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerServiceDefinition;
import io.grpc.solon.annotation.EnableGrpc;
import io.grpc.solon.annotation.GrpcClient;
import io.grpc.solon.annotation.GrpcService;
import io.grpc.solon.integration.GrpcClientBeanInjector;
import io.grpc.solon.integration.GrpcServerProps;
import io.grpc.solon.integration.GrpcServiceBeanBuilder;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.util.LogUtil;

public class XPluginImp
implements Plugin {
    private static Signal _signal;
    Server server;
    Map<Class<?>, Object> serviceMap;
    Map<Class<?>, Object> clientMap;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "grpc 1.49.0/" + Solon.version();
    }

    public void start(AppContext context) {
        if (Solon.app().source().getAnnotation(EnableGrpc.class) == null) {
            return;
        }
        this.serviceMap = new HashMap();
        this.clientMap = new HashMap();
        context.beanBuilderAdd(GrpcService.class, (BeanBuilder)new GrpcServiceBeanBuilder(this.serviceMap));
        context.beanInjectorAdd(GrpcClient.class, (BeanInjector)new GrpcClientBeanInjector(this.clientMap));
        context.lifecycle(-94, () -> this.startForServer(Solon.app()));
    }

    private void startForServer(SolonApp app) throws Throwable {
        if (this.serviceMap.size() == 0) {
            return;
        }
        GrpcServerProps props = new GrpcServerProps(25000);
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        long time_start = System.currentTimeMillis();
        ServerBuilder serverBuilder = ServerBuilder.forPort((int)_port);
        this.serviceMap.forEach((k, v) -> {
            if (v instanceof BindableService) {
                serverBuilder.addService((BindableService)v);
            }
            if (v instanceof ServerServiceDefinition) {
                serverBuilder.addService((ServerServiceDefinition)v);
            }
        });
        this.server = serverBuilder.build().start();
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "grpc", SignalType.HTTP);
        app.signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        LogUtil.global().info("Connector:main: grpc: Started ServerConnector@{grpc://localhost:" + _port + "}");
        LogUtil.global().info("Server:main: grpc: Started (" + XPluginImp.solon_boot_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this.server != null) {
            this.server.shutdown();
            this.server = null;
            LogUtil.global().info("Server:main: grpc: Has Stopped (" + XPluginImp.solon_boot_ver() + ")");
        }
    }
}

