/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.solon.integration;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.solon.annotation.GrpcClient;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.Utils;
import org.noear.solon.core.LoadBalance;

public class GrpcChannelProxy
extends Channel {
    private final Map<String, Channel> channelMap = new ConcurrentHashMap<String, Channel>();
    private LoadBalance upstream;
    private GrpcClient anno;

    public GrpcChannelProxy(GrpcClient anno) {
        this.anno = anno;
        String name = Utils.annoAlias((String)anno.value(), (String)anno.name());
        this.upstream = Utils.isEmpty((String)anno.group()) ? LoadBalance.get((String)name) : LoadBalance.get((String)anno.group(), (String)name);
        if (this.upstream == null) {
            throw new IllegalStateException("No service upstream found: " + name);
        }
    }

    private Channel getChannel() {
        String server = this.upstream.getServer();
        Channel real = this.channelMap.computeIfAbsent(server, k -> {
            URI uri = URI.create(k);
            ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)uri.getHost(), (int)uri.getPort()).usePlaintext();
            return builder.build();
        });
        return real;
    }

    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        return this.getChannel().newCall(methodDescriptor, callOptions);
    }

    public String authority() {
        return this.getChannel().authority();
    }
}

