/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.solon.integration;

import io.grpc.Channel;
import io.grpc.solon.annotation.GrpcClient;
import io.grpc.solon.integration.GrpcChannelProxy;
import io.grpc.stub.AbstractAsyncStub;
import io.grpc.stub.AbstractBlockingStub;
import io.grpc.stub.AbstractFutureStub;
import java.lang.reflect.Method;
import java.util.Map;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.util.ClassUtil;

public class GrpcClientBeanInjector
implements BeanInjector<GrpcClient> {
    private Map<Class<?>, Object> clientMap;

    public GrpcClientBeanInjector(Map<Class<?>, Object> clientMap) {
        this.clientMap = clientMap;
    }

    public void doInject(VarHolder vh, GrpcClient anno) {
        vh.required(true);
        Object grpcCli = this.clientMap.get(vh.getType());
        if (grpcCli != null) {
            vh.setValue(grpcCli);
        } else {
            GrpcChannelProxy grpcChannel = new GrpcChannelProxy(anno);
            Class grpcClz = ClassUtil.loadClass((String)vh.getType().getName().split("\\$")[0]);
            try {
                Method method;
                if (AbstractBlockingStub.class.isAssignableFrom(vh.getType())) {
                    method = grpcClz.getDeclaredMethod("newBlockingStub", Channel.class);
                    grpcCli = method.invoke(null, new Object[]{grpcChannel});
                }
                if (AbstractFutureStub.class.isAssignableFrom(vh.getType())) {
                    method = grpcClz.getDeclaredMethod("newFutureStub", Channel.class);
                    grpcCli = method.invoke(null, new Object[]{grpcChannel});
                }
                if (AbstractAsyncStub.class.isAssignableFrom(vh.getType())) {
                    method = grpcClz.getDeclaredMethod("newStub", Channel.class);
                    grpcCli = method.invoke(null, new Object[]{grpcChannel});
                }
                if (grpcCli != null) {
                    this.clientMap.put(vh.getType(), grpcCli);
                    vh.setValue(grpcCli);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}

