/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.guava.impl;

import com.google.common.util.concurrent.RateLimiter;
import org.noear.solon.cloud.model.BreakerEntrySim;
import org.noear.solon.cloud.model.BreakerException;

public class CloudBreakerEntryImpl
extends BreakerEntrySim {
    RateLimiter limiter;
    int thresholdValue;

    public CloudBreakerEntryImpl(int permitsPerSecond) {
        this.thresholdValue = permitsPerSecond;
        this.loadRules();
    }

    private void loadRules() {
        this.limiter = RateLimiter.create((double)this.thresholdValue);
    }

    public AutoCloseable enter() throws BreakerException {
        if (this.limiter.tryAcquire()) {
            return this;
        }
        throw new BreakerException();
    }

    public void reset(int value) {
        if (this.thresholdValue != value) {
            this.thresholdValue = value;
            this.loadRules();
        }
    }
}

