/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.solon.boot;

import java.io.IOException;
import net.hasor.core.AppContext;
import net.hasor.core.Module;
import net.hasor.solon.boot.BuildConfig;
import net.hasor.solon.boot.EnableHasor;
import net.hasor.solon.boot.EnableHasorWeb;
import net.hasor.solon.boot.Property;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.StringUtils;
import org.noear.solon.XApp;
import org.noear.solon.annotation.XConfiguration;
import org.noear.solon.core.Aop;
import org.noear.solon.core.XEventListener;
import org.noear.solon.event.BeanLoadEndEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XConfiguration
public class HasorConfiguration
implements XEventListener<BeanLoadEndEvent> {
    private static Logger logger = LoggerFactory.getLogger(HasorConfiguration.class);

    public HasorConfiguration() {
        this(XApp.global().source().getAnnotation(EnableHasor.class));
    }

    public HasorConfiguration(EnableHasor enableHasor) {
        Property[] customProperties;
        BuildConfig buildConfig = BuildConfig.getInstance();
        buildConfig.mainConfig = enableHasor.mainConfig();
        buildConfig.useProperties = enableHasor.useProperties();
        for (Class<? extends Module> startWith : enableHasor.startWith()) {
            buildConfig.addModules((Module)Aop.get(startWith));
        }
        if (enableHasor.scanPackages().length != 0) {
            for (String p : enableHasor.scanPackages()) {
                if (p.endsWith(".*")) {
                    XApp.global().beanScan(p.substring(0, p.length() - 2));
                    continue;
                }
                XApp.global().beanScan(p);
            }
        }
        for (Property property : customProperties = enableHasor.customProperties()) {
            String name = property.name();
            if (!StringUtils.isNotBlank((String)name)) continue;
            buildConfig.customProperties.put(name, property.value());
        }
    }

    public void onEvent(BeanLoadEndEvent beanLoadedEvent) {
        if (XApp.global().source().getAnnotation(EnableHasorWeb.class) == null) {
            Aop.wrapAndPut(AppContext.class, (Object)this.initAppContext());
        }
    }

    private AppContext initAppContext() {
        try {
            return BuildConfig.getInstance().build(null);
        }
        catch (IOException e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }
}

