/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.solon.boot;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import net.hasor.core.AppContext;
import net.hasor.core.Hasor;
import net.hasor.core.Module;
import net.hasor.utils.StringUtils;
import org.noear.solon.Solon;
import org.noear.solon.Utils;

public class BuildConfig {
    private static BuildConfig instance;
    public String mainConfig = null;
    public Properties envProperties = null;
    public Properties refProperties = null;
    public Map<Object, Object> customProperties = null;
    public boolean useProperties = true;
    private Set<Module> loadModules = null;
    private Set<Class<?>> needCheckRepeat = new HashSet();

    public static BuildConfig getInstance() {
        if (instance == null) {
            instance = new BuildConfig();
        }
        return instance;
    }

    public BuildConfig() {
        this.customProperties = new HashMap<Object, Object>();
        this.loadModules = new LinkedHashSet<Module>();
        this.envProperties = Solon.cfg();
    }

    public void addModules(Module module) {
        if (this.needCheckRepeat.contains(module.getClass())) {
            return;
        }
        this.needCheckRepeat.add(module.getClass());
        this.loadModules.add(module);
    }

    public AppContext build(Object parentObject) throws IOException {
        URL resource;
        Hasor hasorBuild = parentObject == null ? Hasor.create() : Hasor.create((Object)parentObject);
        hasorBuild.parentClassLoaderWith(BuildConfig.class.getClassLoader());
        String config = this.mainConfig;
        if (!StringUtils.isBlank((String)config) && (resource = Utils.getResource((String)config)) != null) {
            hasorBuild.mainSettingWith(resource);
        }
        if (this.envProperties != null) {
            this.envProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> hasorBuild.addVariable(k.toString(), v.toString())));
        }
        if (this.refProperties != null) {
            this.refProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> hasorBuild.addVariable(k.toString(), v.toString())));
        }
        if (this.customProperties != null) {
            this.customProperties.forEach((k, v) -> hasorBuild.addVariable(k.toString(), v.toString()));
        }
        if (this.useProperties) {
            hasorBuild.importVariablesToSettings();
        }
        return hasorBuild.addModules(new ArrayList<Module>(this.loadModules)).build(new Module[0]);
    }
}

