/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.jaeger.service;

import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.internal.metrics.Metrics;
import io.jaegertracing.internal.metrics.NoopMetricsFactory;
import io.jaegertracing.internal.reporters.CompositeReporter;
import io.jaegertracing.internal.reporters.LoggingReporter;
import io.jaegertracing.internal.reporters.RemoteReporter;
import io.jaegertracing.internal.samplers.ConstSampler;
import io.jaegertracing.spi.MetricsFactory;
import io.jaegertracing.spi.Reporter;
import io.jaegertracing.spi.Sampler;
import io.jaegertracing.spi.Sender;
import io.jaegertracing.thrift.internal.senders.HttpSender;
import io.jaegertracing.thrift.internal.senders.UdpSender;
import io.opentracing.Tracer;
import java.net.URI;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.tracing.service.TracerFactory;

public class JaegerTracerFactory
implements TracerFactory {
    final CloudProps cloudProps;

    public JaegerTracerFactory(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
    }

    public Tracer create() throws Exception {
        UdpSender sender;
        URI serverUri = URI.create(this.cloudProps.getServer());
        if ("http".equals(serverUri.getScheme())) {
            HttpSender.Builder builder = new HttpSender.Builder(this.cloudProps.getServer());
            if (Utils.isNotEmpty((String)this.cloudProps.getToken())) {
                builder.withAuth(this.cloudProps.getToken());
            }
            if (Utils.isNotEmpty((String)this.cloudProps.getUsername())) {
                builder.withAuth(this.cloudProps.getUsername(), this.cloudProps.getPassword());
            }
            sender = builder.build();
        } else {
            sender = new UdpSender(serverUri.getHost(), serverUri.getPort(), 0);
        }
        CompositeReporter compositeReporter = new CompositeReporter(new Reporter[]{new RemoteReporter.Builder().withSender((Sender)sender).build(), new LoggingReporter()});
        Metrics metrics = new Metrics((MetricsFactory)new NoopMetricsFactory());
        return new JaegerTracer.Builder(Solon.cfg().appName()).withReporter((Reporter)compositeReporter).withMetrics(metrics).withExpandExceptionLogs().withSampler((Sampler)new ConstSampler(true)).build();
    }
}

