/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.jedis.impl;

import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.core.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPubSub;

public class JedisEventConsumer
extends JedisPubSub {
    static Logger log = LoggerFactory.getLogger(JedisEventConsumer.class);
    CloudEventObserverManger observerManger;
    String eventChannelName;

    public JedisEventConsumer(CloudProps cloudProps, CloudEventObserverManger observerManger) {
        this.observerManger = observerManger;
        this.eventChannelName = cloudProps.getEventChannel();
    }

    public void onMessage(String channel, String message) {
        try {
            Event event = (Event)ONode.deserialize((String)message, Event.class);
            event.channel(this.eventChannelName);
            this.onReceive(event);
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap((Throwable)ex);
            EventBus.pushTry((Object)ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    private boolean onReceive(Event event) {
        try {
            return this.onReceiveDo(event);
        }
        catch (Throwable e) {
            EventBus.pushTry((Object)e);
            return false;
        }
    }

    private boolean onReceiveDo(Event event) throws Throwable {
        boolean isOk = true;
        CloudEventHandler handler = null;
        String topicNew = Utils.isEmpty((String)event.group()) ? event.topic() : event.group() + ":" + event.topic();
        handler = this.observerManger.getByTopic(topicNew);
        if (handler != null) {
            isOk = handler.handle(event);
        } else {
            log.warn("There is no observer for this event topic[{}]", (Object)topicNew);
        }
        return isOk;
    }
}

