/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.jedis.service;

import java.util.Properties;
import org.noear.redisx.RedisClient;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.service.CloudLockService;
import org.noear.solon.core.Props;

public class CloudLockServiceJedisImpl
implements CloudLockService {
    private final RedisClient client;

    public CloudLockServiceJedisImpl(RedisClient client) {
        this.client = client;
    }

    public CloudLockServiceJedisImpl(CloudProps cloudProps) {
        Props props = cloudProps.getProp("lock");
        if (props.get("server") == null) {
            props.putIfNotNull((Object)"server", (Object)cloudProps.getServer());
        }
        if (props.get("user") == null) {
            props.putIfNotNull((Object)"user", (Object)cloudProps.getUsername());
        }
        if (props.get("password") == null) {
            props.putIfNotNull((Object)"password", (Object)cloudProps.getPassword());
        }
        this.client = new RedisClient((Properties)props);
    }

    public boolean tryLock(String group, String key, int seconds, String holder) {
        if (holder == null) {
            holder = "-";
        }
        String lockName = group + ":" + key;
        return this.client.getLock(lockName).tryLock(seconds, holder);
    }

    public void unLock(String group, String key, String holder) {
        String lockName = group + ":" + key;
        this.client.getLock(lockName).unLock(holder);
    }

    public boolean isLocked(String group, String key) {
        String lockName = group + ":" + key;
        return this.client.getLock(lockName).isLocked();
    }

    public String getHolder(String group, String key) {
        String lockName = group + ":" + key;
        return this.client.getLock(lockName).getHolder();
    }
}

