/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.jedis.service;

import java.util.Properties;
import org.noear.redisx.RedisClient;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.exception.CloudEventException;
import org.noear.solon.cloud.extend.jedis.impl.JedisEventConsumer;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.model.EventTran;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.cloud.service.CloudEventServicePlus;
import org.noear.solon.core.Props;
import org.noear.solon.core.bean.LifecycleBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPubSub;

public class CloudEventServiceJedisImpl
implements CloudEventServicePlus,
LifecycleBean {
    private static final Logger log = LoggerFactory.getLogger(CloudEventServiceJedisImpl.class);
    private final RedisClient client;
    private final CloudProps cloudProps;
    CloudEventObserverManger observerManger = new CloudEventObserverManger();

    public CloudEventServiceJedisImpl(CloudProps cloudProps) {
        Props props = cloudProps.getProp("event");
        if (props.get("server") == null) {
            props.putIfNotNull((Object)"server", (Object)cloudProps.getServer());
        }
        if (props.get("user") == null) {
            props.putIfNotNull((Object)"user", (Object)cloudProps.getUsername());
        }
        if (props.get("password") == null) {
            props.putIfNotNull((Object)"password", (Object)cloudProps.getPassword());
        }
        this.client = new RedisClient((Properties)props);
        this.cloudProps = cloudProps;
    }

    private void beginTransaction(EventTran transaction) throws CloudEventException {
        log.warn("Event transactions are not supported!");
    }

    public boolean publish(Event event) throws CloudEventException {
        if (Utils.isEmpty((String)event.topic())) {
            throw new IllegalArgumentException("Event missing topic");
        }
        if (Utils.isEmpty((String)event.content())) {
            throw new IllegalArgumentException("Event missing content");
        }
        if (Utils.isEmpty((String)event.key())) {
            event.key(Utils.guid());
        }
        if (event.created() == 0L) {
            event.created(System.currentTimeMillis());
        }
        if (event.tran() != null) {
            this.beginTransaction(event.tran());
        }
        String topicNew = Utils.isEmpty((String)event.group()) ? event.topic() : event.group() + ":" + event.topic();
        this.client.open(s -> s.publish(topicNew, ONode.stringify((Object)event)));
        return true;
    }

    public void attention(EventLevel level, String channel, String group, String topic, String tag, int qos, CloudEventHandler observer) {
        String topicNew = Utils.isEmpty((String)group) ? topic : group + ":" + topic;
        this.observerManger.add(topicNew, level, group, topic, tag, qos, observer);
    }

    public void postStart() throws Throwable {
        this.subscribe();
    }

    private void subscribe() {
        if (this.observerManger.topicSize() > 0) {
            try {
                String[] topicAll = new String[this.observerManger.topicAll().size()];
                this.observerManger.topicAll().toArray(topicAll);
                new Thread(() -> this.client.open(s -> s.subscribe((JedisPubSub)new JedisEventConsumer(this.cloudProps, this.observerManger), topicAll))).start();
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public String getChannel() {
        if (this.cloudProps == null) {
            return null;
        }
        return this.cloudProps.getEventChannel();
    }

    public String getGroup() {
        if (this.cloudProps == null) {
            return null;
        }
        return this.cloudProps.getEventGroup();
    }
}

