/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.jmdns.service;

import java.io.IOException;
import java.net.URI;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import org.noear.snack.ONode;
import org.noear.solon.cloud.CloudDiscoveryHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudDiscoveryService;

public class CloudDiscoveryServiceJmdnsImpl
implements CloudDiscoveryService {
    JmDNS jmDNS;

    public CloudDiscoveryServiceJmdnsImpl(CloudProps cloudProps) {
        try {
            this.jmDNS = JmDNS.create();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void register(String group, Instance instance) {
        try {
            String fullyQualitifed = group + ".local.";
            String values = ONode.stringify((Object)instance);
            URI uri = URI.create(instance.address());
            this.jmDNS.registerService(ServiceInfo.create((String)fullyQualitifed, (String)instance.service(), (int)uri.getPort(), (String)values));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void registerState(String group, Instance instance, boolean health) {
    }

    public void deregister(String group, Instance instance) {
        String fullyQualitifed = group + ".local.";
        String values = ONode.stringify((Object)instance);
        URI uri = URI.create(instance.address());
        this.jmDNS.unregisterService(ServiceInfo.create((String)fullyQualitifed, (String)instance.service(), (int)uri.getPort(), (String)values));
    }

    public Discovery find(String group, String service) {
        return null;
    }

    public void attention(String group, String service, CloudDiscoveryHandler observer) {
    }
}

