/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.jmdns.service;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudDiscoveryHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudDiscoveryObserverEntity;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.utils.IntervalUtils;

public class CloudDiscoveryServiceJmdnsImpl
implements CloudDiscoveryService {
    public static final String PREFIX = "solon";
    public static final String DOMAIN = "local";
    JmDNS jmDNS;
    private static final long RETRY_LIMIT_TIME = 5000L;

    public CloudDiscoveryServiceJmdnsImpl(CloudProps cloudProps) {
        try {
            String server = cloudProps.getServer().split(":")[0];
            InetAddress jmDNSAddress = "localhost".equals(server) ? InetAddress.getLocalHost() : InetAddress.getByName(server);
            this.jmDNS = JmDNS.create((InetAddress)jmDNSAddress, (String)jmDNSAddress.toString(), (long)IntervalUtils.getInterval((String)cloudProps.getDiscoveryRefreshInterval("100ms")));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void register(String group, Instance instance) {
        this.registerState(group, instance, true);
    }

    public void registerState(String group, Instance instance, boolean health) {
        int priority = (int)(10.0 - instance.weight() % 10.0);
        int weight = (int)(instance.weight() * 10.0 % 10.0);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(instance.address(), ONode.stringify((Object)instance));
        ServiceInfo serviceInfo = ServiceInfo.create((String)this.getType(group), (String)instance.address(), (String)instance.service(), (int)Integer.parseInt(instance.address().split(":")[1]), (int)weight, (int)priority, (boolean)false, props);
        if (health) {
            try {
                this.jmDNS.registerService(serviceInfo);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.jmDNS.unregisterService(serviceInfo);
        }
    }

    public void deregister(String group, Instance instance) {
        this.registerState(group, instance, false);
    }

    public Discovery find(String group, String service) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        ServiceInfo[] serviceInfos = this.getServiceInfos(group, service);
        Discovery discovery = new Discovery(group, service);
        for (ServiceInfo serviceInfo : serviceInfos) {
            Enumeration nodeKeyList = serviceInfo.getPropertyNames();
            while (nodeKeyList.hasMoreElements()) {
                Instance instance = (Instance)ONode.deserialize((String)serviceInfo.getPropertyString((String)nodeKeyList.nextElement()), Instance.class);
                discovery.instanceAdd(instance);
            }
        }
        return discovery;
    }

    public void attention(String group, String service, CloudDiscoveryHandler observer) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        CloudDiscoveryObserverEntity entity = new CloudDiscoveryObserverEntity(group, service, observer);
        final Consumer<ServiceEvent> handle = event -> {
            Discovery discovery = this.find(entity.group, service);
            entity.handle(discovery);
        };
        this.jmDNS.addServiceListener(this.getType(group), new ServiceListener(){

            public void serviceAdded(ServiceEvent event) {
                handle.accept(event);
            }

            public void serviceRemoved(ServiceEvent event) {
                handle.accept(event);
            }

            public void serviceResolved(ServiceEvent event) {
                handle.accept(event);
            }
        });
    }

    public void close() throws IOException {
        if (this.jmDNS != null) {
            this.jmDNS.close();
        }
    }

    private ServiceInfo[] getServiceInfos(String group, String service) {
        String type = this.getType(group);
        ServiceInfo[] serviceInfos = null;
        long begin = System.currentTimeMillis();
        while (Utils.isEmpty(serviceInfos) && System.currentTimeMillis() - begin < 5000L) {
            serviceInfos = (ServiceInfo[])this.jmDNS.listBySubtype(type).get(service);
        }
        return serviceInfos;
    }

    private String getType(String group) {
        return String.format("_%s._%s.%s.", group, PREFIX, DOMAIN);
    }
}

