/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.solon;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.solon.LettuceConfig;
import io.lettuce.solon.LettuceProperties;
import io.lettuce.solon.LettuceSentinel;
import io.lettuce.solon.RedisMode;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class LettuceSupplier
extends LettuceProperties
implements Supplier<AbstractRedisClient> {
    private Consumer<RedisURI.Builder> configHandler;

    public LettuceSupplier withConfig(Consumer<RedisURI.Builder> configHandler) {
        this.configHandler = configHandler;
        return this;
    }

    @Override
    public AbstractRedisClient get() {
        RedisMode redisMode = RedisMode.getRedisMode(this.getRedisMode());
        RedisURI redisUri = this.getRedisURI();
        if (redisMode.equals((Object)RedisMode.STANDALONE)) {
            return RedisClient.create((RedisURI)redisUri);
        }
        if (redisMode.equals((Object)RedisMode.CLUSTER)) {
            return RedisClusterClient.create((RedisURI)redisUri);
        }
        if (redisMode.equals((Object)RedisMode.SENTINEL)) {
            return RedisClient.create((RedisURI)redisUri);
        }
        throw new IllegalArgumentException("redis mode error");
    }

    public RedisURI getRedisURI() {
        if (this.getRedisUri() == null) {
            return this.lettuceCfg2Uri();
        }
        return RedisURI.create((String)super.getRedisUri());
    }

    private RedisURI lettuceCfg2Uri() {
        LettuceConfig config = this.getConfig();
        RedisURI.Builder builder = config.getSocket() != null ? RedisURI.Builder.socket((String)config.getSocket()) : (config.getHost() != null ? RedisURI.Builder.redis((String)config.getHost(), (int)config.getPort()) : RedisURI.Builder.redis((String)"localhost", (int)config.getPort()));
        if (config.getHost() != null) {
            builder.withHost(config.getHost());
        }
        if (config.getPort() != 0) {
            builder.withPort(config.getPort());
        }
        builder.withDatabase(config.getDatabase());
        if (config.getClientName() != null) {
            builder.withClientName(config.getClientName());
        }
        if (config.getPassword() != null) {
            builder.withPassword(config.getPassword());
        }
        if (config.getUsername() != null && config.getPassword() != null) {
            builder.withAuthentication(config.getUsername(), (CharSequence)config.getPassword());
        }
        if (config.isSsl()) {
            builder.withSsl(config.isSsl());
        }
        if (config.isStartTls()) {
            builder.withStartTls(config.isStartTls());
        }
        if (config.getVerifyMode() != null) {
            builder.withVerifyPeer(config.getVerifyMode());
        }
        if (config.getTimeout() != null) {
            builder.withTimeout(Duration.ofSeconds(config.getTimeout()));
        }
        if (config.getSentinelMasterId() != null) {
            builder.withSentinelMasterId(config.getSentinelMasterId());
        }
        if (config.getSentinels() != null && !config.getSentinels().isEmpty()) {
            for (LettuceSentinel sentinel : config.getSentinels()) {
                builder.withSentinel(sentinel.getHost(), sentinel.getPort(), (CharSequence)sentinel.getPassword());
            }
        }
        if (this.configHandler != null) {
            this.configHandler.accept(builder);
        }
        return builder.build();
    }
}

