/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.solon.config;

import com.yomahub.liteflow.core.FlowExecutor;
import com.yomahub.liteflow.monitor.MonitorBus;
import com.yomahub.liteflow.property.LiteflowConfig;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.AopContext;

@Configuration
public class LiteflowMainAutoConfiguration {
    @Inject(value="${liteflow.parseOnStart}", required=false)
    boolean parseOnStart;
    @Inject(value="${liteflow.monitor.enableLog}", required=false)
    boolean enableLog;
    @Inject
    AopContext aopContext;

    @Bean
    public FlowExecutor flowExecutor(LiteflowConfig liteflowConfig) {
        FlowExecutor flowExecutor = new FlowExecutor();
        flowExecutor.setLiteflowConfig(liteflowConfig);
        if (this.parseOnStart) {
            this.aopContext.beanOnloaded(c -> flowExecutor.init(true));
        }
        return flowExecutor;
    }

    @Bean
    public MonitorBus monitorBus(LiteflowConfig liteflowConfig) {
        if (this.enableLog) {
            return new MonitorBus(liteflowConfig);
        }
        return null;
    }
}

