/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.solon;

import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.enums.LiteFlowMethodEnum;
import com.yomahub.liteflow.slot.Slot;
import java.lang.reflect.Method;
import org.noear.solon.core.BeanWrap;

public class NodeComponentOfMethod
extends NodeComponent {
    final BeanWrap beanWrap;
    final Method method;
    final LiteFlowMethodEnum methodEnum;

    public NodeComponentOfMethod(BeanWrap beanWrap, Method method, LiteFlowMethodEnum methodEnum) {
        this.beanWrap = beanWrap;
        this.method = method;
        this.methodEnum = methodEnum;
    }

    public void process() throws Exception {
        if (this.methodEnum != LiteFlowMethodEnum.PROCESS) {
            return;
        }
        if (this.method.getParameterCount() == 0) {
            this.method.invoke(this.beanWrap.get(), new Object[0]);
        } else if (this.method.getParameterCount() == 1) {
            this.method.invoke(this.beanWrap.get(), new Object[]{this});
        } else {
            String methodFullName = this.beanWrap.clz().getName() + "::" + this.method.getName();
            throw new RuntimeException("NodeComponent method parameter cannot be more than one: " + methodFullName);
        }
    }

    public <T> void beforeProcess(String nodeId, Slot slot) {
        if (this.methodEnum != LiteFlowMethodEnum.BEFORE_PROCESS) {
            return;
        }
    }

    public <T> void afterProcess(String nodeId, Slot slot) {
        if (this.methodEnum != LiteFlowMethodEnum.AFTER_PROCESS) {
            return;
        }
    }

    public void onError() throws Exception {
        if (this.methodEnum != LiteFlowMethodEnum.ON_ERROR) {
            return;
        }
    }

    public void onSuccess() throws Exception {
        if (this.methodEnum != LiteFlowMethodEnum.ON_SUCCESS) {
            return;
        }
    }
}

