/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.solon;

import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.enums.LiteFlowMethodEnum;
import com.yomahub.liteflow.exception.LiteFlowException;
import com.yomahub.liteflow.slot.Slot;
import java.lang.reflect.Method;
import org.noear.solon.core.BeanWrap;

public class NodeComponentOfMethod
extends NodeComponent {
    final BeanWrap beanWrap;
    final Method method;
    final LiteFlowMethodEnum methodEnum;

    public NodeComponentOfMethod(BeanWrap beanWrap, Method method, LiteFlowMethodEnum methodEnum) {
        this.beanWrap = beanWrap;
        this.method = method;
        this.methodEnum = methodEnum;
        if (method.getParameterCount() > 1) {
            String methodFullName = beanWrap.clz().getName() + "::" + method.getName();
            throw new LiteFlowException("NodeComponent method parameter cannot be more than one: " + methodFullName);
        }
        if (method.getReturnType() != Void.class && method.getReturnType() != Void.TYPE) {
            String methodFullName = beanWrap.clz().getName() + "::" + method.getName();
            throw new LiteFlowException("NodeComponent method returnType can only be void: " + methodFullName);
        }
    }

    private void exec() throws Exception {
        if (this.method.getParameterCount() == 0) {
            this.method.invoke(this.beanWrap.get(), new Object[0]);
        } else {
            this.method.invoke(this.beanWrap.get(), new Object[]{this});
        }
    }

    public void process() throws Exception {
        if (this.methodEnum != LiteFlowMethodEnum.PROCESS) {
            return;
        }
        this.exec();
    }

    public <T> void beforeProcess(String nodeId, Slot slot) {
        if (this.methodEnum != LiteFlowMethodEnum.BEFORE_PROCESS) {
            return;
        }
        try {
            this.exec();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void afterProcess(String nodeId, Slot slot) {
        if (this.methodEnum != LiteFlowMethodEnum.AFTER_PROCESS) {
            return;
        }
        try {
            this.exec();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onError() throws Exception {
        if (this.methodEnum != LiteFlowMethodEnum.ON_ERROR) {
            return;
        }
        this.exec();
    }

    public void onSuccess() throws Exception {
        if (this.methodEnum != LiteFlowMethodEnum.ON_SUCCESS) {
            return;
        }
        this.exec();
    }
}

