/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.spi.solon;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.exception.ConfigErrorException;
import com.yomahub.liteflow.spi.PathContentParser;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.noear.solon.core.util.ResourceUtil;

public class SolonPathContentParser
implements PathContentParser {
    public List<String> parseContent(List<String> pathList) throws Exception {
        if (CollectionUtil.isEmpty(pathList)) {
            throw new ConfigErrorException("rule source must not be null");
        }
        ArrayList<URL> allResource = new ArrayList<URL>();
        for (String path : pathList) {
            if (FileUtil.isAbsolutePath((String)path) && FileUtil.isFile((String)path)) {
                allResource.add(new File(path).toURI().toURL());
                continue;
            }
            if (path.startsWith("classpath:")) {
                path = path.substring("classpath:".length());
            }
            allResource.add(ResourceUtil.getResource((String)path));
        }
        HashSet fileTypeSet = new HashSet();
        allResource.forEach(resource -> fileTypeSet.add(FileUtil.extName((String)resource.getPath())));
        if (fileTypeSet.size() != 1) {
            throw new ConfigErrorException("config error,please use the same type of configuration");
        }
        ArrayList<String> contentList = new ArrayList<String>();
        for (URL resource2 : allResource) {
            String content = IoUtil.read((InputStream)resource2.openStream(), (Charset)CharsetUtil.CHARSET_UTF_8);
            if (!StrUtil.isNotBlank((CharSequence)content)) continue;
            contentList.add(content);
        }
        return contentList;
    }

    public int priority() {
        return 1;
    }
}

