/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.spi.solon;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.stream.StreamUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.exception.ConfigErrorException;
import com.yomahub.liteflow.spi.PathContentParser;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.solon.Utils;

public class SolonPathContentParser
implements PathContentParser {
    public List<String> parseContent(List<String> pathList) throws Exception {
        List<URL> allResource = SolonPathContentParser.getUrls(pathList);
        ArrayList<String> contentList = new ArrayList<String>();
        for (URL resource : allResource) {
            String content = IoUtil.read((InputStream)resource.openStream(), (Charset)CharsetUtil.CHARSET_UTF_8);
            if (!StrUtil.isNotBlank((CharSequence)content)) continue;
            contentList.add(content);
        }
        return contentList;
    }

    public List<String> getFileAbsolutePath(List<String> pathList) throws Exception {
        List<URL> allResource = SolonPathContentParser.getUrls(pathList);
        return StreamUtil.of(allResource).map(URL::getPath).filter(FileUtil::isFile).collect(Collectors.toList());
    }

    private static List<URL> getUrls(List<String> pathList) throws MalformedURLException {
        if (CollectionUtil.isEmpty(pathList)) {
            throw new ConfigErrorException("rule source must not be null");
        }
        ArrayList<URL> allResource = new ArrayList<URL>();
        for (String path : pathList) {
            if (FileUtil.isAbsolutePath((String)path) && FileUtil.isFile((String)path)) {
                allResource.add(new File(path).toURI().toURL());
                continue;
            }
            if (path.startsWith("classpath:")) {
                path = path.substring("classpath:".length());
            }
            if (Utils.getResource((String)path) == null) continue;
            allResource.add(Utils.getResource((String)path));
        }
        HashSet fileTypeSet = new HashSet();
        allResource.forEach(resource -> fileTypeSet.add(FileUtil.extName((String)resource.getPath())));
        if (fileTypeSet.size() > 1) {
            throw new ConfigErrorException("config error,please use the same type of configuration");
        }
        return allResource;
    }

    public int priority() {
        return 1;
    }
}

