/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.local.service;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.model.Pack;
import org.noear.solon.cloud.service.CloudI18nService;
import org.noear.solon.core.Props;

public class CloudI18nServiceLocalImpl
implements CloudI18nService {
    static final String DEFAULT_GROUP = "DEFAULT_GROUP";
    static final String I18N_KEY_FORMAT = "META-INF/solon-cloud/i18n@%s:%s-%s";

    public Pack pull(String group, String packName, Locale locale) {
        if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
            group = DEFAULT_GROUP;
        }
        Pack pack = new Pack(locale);
        pack.setData(new Props());
        String bundleName = String.format(I18N_KEY_FORMAT, group, packName, locale.getLanguage());
        Properties tmp = this.getProps(bundleName);
        if (tmp != null) {
            pack.getData().putAll((Map)tmp);
        }
        if ((tmp = this.getProps(bundleName = String.format(I18N_KEY_FORMAT, group, packName, locale))) != null) {
            pack.getData().putAll((Map)tmp);
        }
        return pack;
    }

    private Properties getProps(String uri) {
        try {
            String txt = Utils.getResourceAsString((String)uri);
            if (Utils.isEmpty((String)txt)) {
                return null;
            }
            return Utils.buildProperties((String)txt);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

