/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.local.service;

import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.exception.CloudEventException;
import org.noear.solon.cloud.exception.CloudJobException;
import org.noear.solon.cloud.extend.local.LocalProps;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.cloud.service.CloudEventServicePlus;
import org.noear.solon.core.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventServiceLocalImpl
implements CloudEventServicePlus {
    static Logger log = LoggerFactory.getLogger(CloudEventServiceLocalImpl.class);
    private CloudEventObserverManger observerManger = new CloudEventObserverManger();
    private String channel;
    private String group;

    public boolean publish(Event event) throws CloudEventException {
        if (Utils.isEmpty((String)event.topic())) {
            throw new IllegalArgumentException("Event missing topic");
        }
        if (Utils.isEmpty((String)event.content())) {
            throw new IllegalArgumentException("Event missing content");
        }
        Utils.async(() -> {
            try {
                this.publishDo(event);
            }
            catch (Throwable e) {
                EventBus.push((Object)new CloudJobException(e));
            }
        });
        return true;
    }

    private void publishDo(Event event) throws Throwable {
        String topicNew = Utils.isEmpty((String)event.group()) ? event.topic() : event.group() + ":" + event.topic();
        CloudEventHandler eventHandler = this.observerManger.get(topicNew);
        if (eventHandler == null) {
            eventHandler.handle(event);
        } else {
            log.warn("There is no observer for this event topic[{}]", (Object)event.topic());
        }
    }

    public void attention(EventLevel level, String channel, String group, String topic, CloudEventHandler observer) {
        String topicNew = Utils.isEmpty((String)group) ? topic : group + ":" + topic;
        this.observerManger.add(topicNew, level, group, topic, observer);
    }

    public String getChannel() {
        if (this.channel == null) {
            this.channel = LocalProps.instance.getEventChannel();
        }
        return this.channel;
    }

    public String getGroup() {
        if (this.group == null) {
            this.group = LocalProps.instance.getEventGroup();
        }
        return this.group;
    }
}

