/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.local.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudConfigHandler;
import org.noear.solon.cloud.exception.CloudConfigException;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.service.CloudConfigService;

public class CloudConfigServiceLocalImpl
implements CloudConfigService {
    static final String DEFAULT_GROUP = "DEFAULT_GROUP";
    static final String CONFIG_KEY_FORMAT = "config@%s_%s";
    Map<String, Config> configMap = new HashMap<String, Config>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config pull(String group, String name) {
        String configKey;
        Config configVal;
        if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
            group = DEFAULT_GROUP;
        }
        if ((configVal = this.configMap.get(configKey = String.format(CONFIG_KEY_FORMAT, group, name))) == null) {
            Map<String, Config> map = this.configMap;
            synchronized (map) {
                configVal = this.configMap.get(configKey);
                if (configVal == null) {
                    try {
                        String resourceKey = "META-INF/solon-cloud/" + configKey;
                        String value = Utils.getResourceAsString((String)resourceKey);
                        configVal = new Config(group, name, value, 0L);
                        this.configMap.put(configKey, configVal);
                    }
                    catch (IOException e) {
                        throw new CloudConfigException((Throwable)e);
                    }
                }
            }
        }
        return configVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean push(String group, String name, String value) {
        if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
            group = DEFAULT_GROUP;
        }
        String configKey = String.format(CONFIG_KEY_FORMAT, group, name);
        Config configVal = this.pull(group, name);
        Map<String, Config> map = this.configMap;
        synchronized (map) {
            if (configVal == null) {
                configVal = new Config(group, name, value, 0L);
                this.configMap.put(configKey, configVal);
            }
            if (configVal != null) {
                configVal.updateValue(value, configVal.version() + 1L);
            }
        }
        return true;
    }

    public boolean remove(String group, String name) {
        if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
            group = DEFAULT_GROUP;
        }
        String configKey = String.format(CONFIG_KEY_FORMAT, group, name);
        this.configMap.remove(configKey);
        return true;
    }

    public void attention(String group, String name, CloudConfigHandler observer) {
    }
}

