/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.local.impl.job;

import java.util.Date;
import org.noear.solon.Utils;
import org.noear.solon.cloud.exception.CloudJobException;
import org.noear.solon.cloud.extend.local.impl.job.cron.CronExpressionPlus;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.RunUtil;

class JobEntity
extends Thread {
    private CronExpressionPlus cron;
    private long fixedRate;
    final Runnable runnable;
    private boolean isCanceled;
    private long sleepMillis;
    private Date baseTime;
    private Date nextTime;

    public JobEntity(String name, long fixedRate, Runnable runnable) {
        this(name, null, fixedRate, runnable);
    }

    public JobEntity(String name, CronExpressionPlus cron, Runnable runnable) {
        this(name, cron, 0L, runnable);
    }

    private JobEntity(String name, CronExpressionPlus cron, long fixedRate, Runnable runnable) {
        this.cron = cron;
        this.fixedRate = fixedRate;
        this.runnable = runnable;
        this.baseTime = new Date();
        if (Utils.isNotEmpty((String)name)) {
            this.setName("Job:" + name);
        }
    }

    protected void reset(CronExpressionPlus cron, long fixedRate) {
        this.cron = cron;
        this.fixedRate = fixedRate;
        this.baseTime = new Date(System.currentTimeMillis() + this.sleepMillis);
    }

    public void cancel() {
        this.isCanceled = true;
    }

    @Override
    public void run() {
        while (!this.isCanceled) {
            try {
                this.scheduling();
            }
            catch (Throwable e) {
                e = Utils.throwableUnwrap((Throwable)e);
                EventBus.push((Object)new CloudJobException(e));
            }
        }
    }

    private void scheduling() throws Throwable {
        if (this.fixedRate > 0L) {
            this.sleepMillis = System.currentTimeMillis() - this.baseTime.getTime();
            if (this.sleepMillis >= this.fixedRate) {
                this.baseTime = new Date();
                this.execAsParallel();
                this.sleepMillis = this.fixedRate;
            } else {
                this.sleepMillis = 100L;
            }
            this.sleep0(this.sleepMillis);
        } else {
            this.nextTime = this.cron.getNextValidTimeAfter(this.baseTime);
            this.sleepMillis = System.currentTimeMillis() - this.nextTime.getTime();
            if (this.sleepMillis >= 0L) {
                this.baseTime = this.nextTime;
                this.nextTime = this.cron.getNextValidTimeAfter(this.baseTime);
                if (this.sleepMillis <= 1000L) {
                    this.execAsParallel();
                    this.sleepMillis = System.currentTimeMillis() - this.nextTime.getTime();
                }
            }
            this.sleep0(this.sleepMillis);
        }
    }

    private void execAsParallel() {
        RunUtil.parallel(this::exec0);
    }

    private void exec0() {
        try {
            this.runnable.run();
        }
        catch (Throwable e) {
            EventBus.push((Object)e);
        }
    }

    private void sleep0(long sleep) {
        if (sleep < 0L) {
            sleep = 100L;
        }
        try {
            Thread.sleep(sleep);
        }
        catch (Exception e) {
            EventBus.push((Object)e);
        }
    }
}

