/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.local.impl.job;

import java.text.ParseException;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.noear.solon.Utils;
import org.noear.solon.cloud.extend.local.impl.job.JobEntity;
import org.noear.solon.cloud.extend.local.impl.job.cron.CronExpressionPlus;
import org.noear.solon.cloud.extend.local.impl.job.cron.CronUtils;

public class JobManager {
    private static Map<String, JobEntity> jobEntityMap = new HashMap<String, JobEntity>();
    private static boolean isStarted = false;

    public static void add(String name, String cron, Runnable runnable) throws ParseException {
        CronExpressionPlus cronX = CronUtils.get(cron);
        JobManager.addDo(name, new JobEntity(name, cronX, runnable));
    }

    public static void add(String name, String cron, String zone, Runnable runnable) throws ParseException {
        CronExpressionPlus cronX = CronUtils.get(cron);
        if (Utils.isNotEmpty((String)zone)) {
            cronX.setTimeZone(TimeZone.getTimeZone(ZoneId.of(zone)));
        }
        JobManager.addDo(name, new JobEntity(name, cronX, runnable));
    }

    public static void add(String name, long fixedRate, Runnable runnable) {
        JobManager.addDo(name, new JobEntity(name, fixedRate, runnable));
    }

    private static void addDo(String name, JobEntity jobEntity) {
        jobEntityMap.putIfAbsent(name, jobEntity);
        if (isStarted) {
            jobEntity.start();
        }
    }

    public static boolean contains(String name) {
        return jobEntityMap.containsKey(name);
    }

    public static int count() {
        return jobEntityMap.size();
    }

    public static void remove(String name) {
        JobEntity jobEntity = jobEntityMap.get(name);
        if (jobEntity != null) {
            jobEntity.cancel();
            jobEntityMap.remove(name);
        }
    }

    public static void reset(String name, long fixedRate) {
        JobEntity jobEntity = jobEntityMap.get(name);
        if (jobEntity != null) {
            jobEntity.reset(null, fixedRate);
        }
    }

    public static void reset(String name, String cron) throws ParseException {
        JobEntity jobEntity = jobEntityMap.get(name);
        if (jobEntity != null) {
            CronExpressionPlus cronX = CronUtils.get(cron);
            jobEntity.reset(cronX, 0L);
        }
    }

    public static Runnable getRunnable(String name) {
        JobEntity jobEntity = jobEntityMap.get(name);
        if (jobEntity != null) {
            return jobEntity.runnable;
        }
        return null;
    }

    public static void start() {
        for (JobEntity job : jobEntityMap.values()) {
            job.start();
        }
        isStarted = true;
    }

    public static void stop() {
        for (JobEntity job : jobEntityMap.values()) {
            job.cancel();
        }
        isStarted = false;
    }
}

