/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.local.service;

import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.exception.CloudEventException;
import org.noear.solon.cloud.extend.local.impl.event.EventRunnable;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.model.EventObserver;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.cloud.service.CloudEventServicePlus;
import org.noear.solon.cloud.utils.ExpirationUtils;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.RunUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventServiceLocalImpl
implements CloudEventServicePlus {
    static Logger log = LoggerFactory.getLogger(CloudEventServiceLocalImpl.class);
    private CloudProps cloudProps;
    private CloudEventObserverManger observerManger = new CloudEventObserverManger();
    private String channel;
    private String group;

    public CloudEventServiceLocalImpl(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
    }

    public boolean publish(Event event) throws CloudEventException {
        if (Utils.isEmpty((String)event.topic())) {
            throw new IllegalArgumentException("Event missing topic");
        }
        if (Utils.isEmpty((String)event.content())) {
            throw new IllegalArgumentException("Event missing content");
        }
        long scheduled_millis = 0L;
        if (event.scheduled() != null) {
            scheduled_millis = event.scheduled().getTime() - System.currentTimeMillis();
        }
        if (scheduled_millis > 0L) {
            RunUtil.delay((Runnable)new EventRunnable(this, event), (long)scheduled_millis);
        } else {
            RunUtil.async(() -> {
                try {
                    this.distribute(event);
                }
                catch (Throwable e) {
                    EventBus.publishTry((Object)new CloudEventException(e));
                }
            });
        }
        return true;
    }

    public void distribute(Event event) throws Throwable {
        String topicNew = Utils.isEmpty((String)event.group()) ? event.topic() : event.group() + ":" + event.topic();
        boolean isOk = false;
        try {
            EventObserver eventHandler = this.observerManger.getByTopic(topicNew);
            if (eventHandler != null) {
                isOk = eventHandler.handle(event);
            } else {
                log.warn("There is no observer for this event topic[{}]", (Object)event.topic());
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        if (!isOk) {
            event.times(event.times() + 1);
            RunUtil.delay((Runnable)new EventRunnable(this, event), (long)ExpirationUtils.getExpiration((int)event.times()));
        }
    }

    public void attention(EventLevel level, String channel, String group, String topic, String tag, int qos, CloudEventHandler observer) {
        String topicNew = Utils.isEmpty((String)group) ? topic : group + ":" + topic;
        this.observerManger.add(topicNew, level, group, topic, tag, qos, observer);
    }

    public String getChannel() {
        if (this.channel == null) {
            this.channel = this.cloudProps.getEventChannel();
        }
        return this.channel;
    }

    public String getGroup() {
        if (this.group == null) {
            this.group = this.cloudProps.getEventGroup();
        }
        return this.group;
    }
}

