/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.local;

import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.local.impl.job.JobManager;
import org.noear.solon.cloud.extend.local.service.CloudConfigServiceLocalImpl;
import org.noear.solon.cloud.extend.local.service.CloudDiscoveryServiceLocalImpl;
import org.noear.solon.cloud.extend.local.service.CloudEventServiceLocalImpl;
import org.noear.solon.cloud.extend.local.service.CloudFileServiceLocalImpl;
import org.noear.solon.cloud.extend.local.service.CloudI18nServiceLocalImpl;
import org.noear.solon.cloud.extend.local.service.CloudJobServiceLocalImpl;
import org.noear.solon.cloud.extend.local.service.CloudListServiceLocalImpl;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.service.CloudEventServicePlus;
import org.noear.solon.cloud.service.CloudFileService;
import org.noear.solon.cloud.service.CloudI18nService;
import org.noear.solon.cloud.service.CloudJobService;
import org.noear.solon.cloud.service.CloudListService;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.ResourceUtil;

public class XPluginImp
implements Plugin {
    public void start(AppContext context) throws Throwable {
        CloudProps cloudProps = new CloudProps(context, "local");
        if (Utils.isEmpty((String)cloudProps.getServer())) {
            return;
        }
        if (cloudProps.getConfigEnable()) {
            CloudManager.register((CloudConfigService)new CloudConfigServiceLocalImpl(cloudProps));
            CloudClient.configLoad((String)cloudProps.getConfigLoad());
        }
        if (cloudProps.getDiscoveryEnable()) {
            CloudManager.register((CloudDiscoveryService)new CloudDiscoveryServiceLocalImpl());
        }
        if (cloudProps.getEventEnable()) {
            CloudManager.register((CloudEventServicePlus)new CloudEventServiceLocalImpl(cloudProps));
        }
        if (cloudProps.getI18nEnable()) {
            CloudManager.register((CloudI18nService)new CloudI18nServiceLocalImpl(cloudProps));
        }
        if (cloudProps.getJobEnable()) {
            CloudManager.register((CloudJobService)new CloudJobServiceLocalImpl());
            context.lifecycle(-96, () -> {
                if (JobManager.count() > 0) {
                    JobManager.start();
                }
            });
        }
        if (cloudProps.getListEnable()) {
            CloudManager.register((CloudListService)new CloudListServiceLocalImpl(cloudProps));
        }
        if (cloudProps.getFileEnable()) {
            if (Utils.isNotEmpty((String)cloudProps.getServer()) && !ResourceUtil.hasClasspath((String)cloudProps.getServer())) {
                CloudManager.register((CloudFileService)new CloudFileServiceLocalImpl(cloudProps.getServer()));
            } else {
                LogUtil.global().warn("The local file service cannot be enabled: no server configuration");
            }
        }
    }

    public void stop() throws Throwable {
        JobManager.stop();
    }
}

