/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.local.service;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.cloud.CloudDiscoveryHandler;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudDiscoveryObserverEntity;
import org.noear.solon.cloud.service.CloudDiscoveryService;

public class CloudDiscoveryServiceLocalImpl
implements CloudDiscoveryService {
    Map<String, Discovery> serviceMap = new HashMap<String, Discovery>();
    Map<CloudDiscoveryHandler, CloudDiscoveryObserverEntity> observerMap = new HashMap<CloudDiscoveryHandler, CloudDiscoveryObserverEntity>();

    public void register(String group, Instance instance) {
        Discovery discovery = this.serviceMap.get(instance.service());
        if (discovery == null) {
            discovery = new Discovery(instance.service());
            this.serviceMap.put(instance.service(), discovery);
        }
        discovery.instanceAdd(instance);
        this.onRegister(discovery);
    }

    public void registerState(String group, Instance instance, boolean health) {
    }

    public void deregister(String group, Instance instance) {
    }

    public Discovery find(String group, String service) {
        Discovery tmp = this.serviceMap.get(service);
        if (tmp == null) {
            tmp = new Discovery(service);
        }
        return tmp;
    }

    public void attention(String group, String service, CloudDiscoveryHandler observer) {
        this.observerMap.put(observer, new CloudDiscoveryObserverEntity(group, service, observer));
    }

    private void onRegister(Discovery discovery) {
        if (this.serviceMap.containsKey(discovery.service())) {
            this.observerMap.forEach((k, v) -> {
                if (discovery.service().equals(v.service)) {
                    v.handle(discovery);
                }
            });
        }
    }
}

