/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.local.impl.job;

import java.util.Date;
import java.util.concurrent.Future;
import org.noear.java_cron.CronExpressionPlus;
import org.noear.solon.Utils;
import org.noear.solon.core.Lifecycle;
import org.noear.solon.core.util.RunUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobEntity
implements Lifecycle {
    static final Logger log = LoggerFactory.getLogger(JobEntity.class);
    private String name;
    private String description;
    private CronExpressionPlus cron;
    private long fixedRate;
    final Runnable runnable;
    private boolean isStopped;
    private long sleepMillis;
    private Date baseTime;
    private Date nextTime;
    private Future<?> jobFuture;

    public JobEntity(String name, String description, long fixedRate, Runnable runnable) {
        this(name, description, null, fixedRate, runnable);
    }

    public JobEntity(String name, String description, CronExpressionPlus cron, Runnable runnable) {
        this(name, description, cron, 0L, runnable);
    }

    private JobEntity(String name, String description, CronExpressionPlus cron, long fixedRate, Runnable runnable) {
        this.cron = cron;
        this.name = name;
        this.description = description;
        this.fixedRate = fixedRate;
        this.runnable = runnable;
        this.baseTime = new Date();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    protected void reset(CronExpressionPlus cron, long fixedRate) {
        this.cron = cron;
        this.fixedRate = fixedRate;
        this.baseTime = new Date(System.currentTimeMillis() + this.sleepMillis);
    }

    public void stop() {
        this.isStopped = true;
        if (this.jobFuture != null) {
            this.jobFuture.cancel(true);
        }
    }

    public void start() {
        this.isStopped = false;
        RunUtil.parallel(this::run);
    }

    private void run() {
        block4: {
            if (this.isStopped) {
                return;
            }
            try {
                this.scheduling();
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) break block4;
                e = Utils.throwableUnwrap((Throwable)e);
                log.warn(e.getMessage(), e);
            }
        }
        if (this.sleepMillis < 0L) {
            this.sleepMillis = 100L;
        }
        RunUtil.delay(this::run, (long)this.sleepMillis);
    }

    private void scheduling() throws Throwable {
        if (this.fixedRate > 0L) {
            this.sleepMillis = System.currentTimeMillis() - this.baseTime.getTime();
            if (this.sleepMillis >= this.fixedRate) {
                this.baseTime = new Date();
                this.execAsParallel();
                this.sleepMillis = this.fixedRate;
            } else {
                this.sleepMillis = 100L;
            }
        } else {
            this.nextTime = this.cron.getNextValidTimeAfter(this.baseTime);
            this.sleepMillis = System.currentTimeMillis() - this.nextTime.getTime();
            if (this.sleepMillis >= 0L) {
                this.baseTime = this.nextTime;
                this.nextTime = this.cron.getNextValidTimeAfter(this.baseTime);
                if (this.sleepMillis <= 1000L) {
                    this.execAsParallel();
                    this.sleepMillis = System.currentTimeMillis() - this.nextTime.getTime();
                }
            }
        }
    }

    private void execAsParallel() {
        this.jobFuture = RunUtil.parallel(this::exec0);
    }

    private void exec0() {
        try {
            this.runnable.run();
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }
}

