/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.local.impl.job;

import java.util.Date;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import org.noear.java_cron.CronExpressionPlus;
import org.noear.solon.Utils;
import org.noear.solon.core.Lifecycle;
import org.noear.solon.core.util.RunUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobEntity
implements Lifecycle {
    static final Logger log = LoggerFactory.getLogger(JobEntity.class);
    private final String name;
    private final String description;
    protected final Runnable runnable;
    private CronExpressionPlus cron;
    private long fixedRate;
    private long delayMillis;
    private Date nextTime;
    private ScheduledFuture<?> jobFutureOfFixed;
    private Future<?> jobFutureOfCron;
    private boolean isStarted = false;

    public JobEntity(String name, String description, long fixedRate, Runnable runnable) {
        this(name, description, null, fixedRate, runnable);
    }

    public JobEntity(String name, String description, CronExpressionPlus cron, Runnable runnable) {
        this(name, description, cron, 0L, runnable);
    }

    private JobEntity(String name, String description, CronExpressionPlus cron, long fixedRate, Runnable runnable) {
        this.name = name;
        this.description = description;
        this.runnable = runnable;
        this.cron = cron;
        this.fixedRate = fixedRate;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    protected void reset(CronExpressionPlus cron, long fixedRate) {
        this.cron = cron;
        this.fixedRate = fixedRate;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void start() {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        this.nextTime = null;
        if (this.fixedRate > 0L) {
            this.jobFutureOfFixed = RunUtil.scheduleAtFixedRate(this::exec0, (long)0L, (long)this.fixedRate);
        } else {
            RunUtil.async(this::run);
        }
    }

    public void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        if (this.jobFutureOfFixed != null) {
            this.jobFutureOfFixed.cancel(false);
        }
        if (this.jobFutureOfCron != null) {
            this.jobFutureOfCron.cancel(false);
        }
    }

    private void run() {
        if (!this.isStarted) {
            return;
        }
        try {
            this.runAsCron();
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap((Throwable)e);
            if (e instanceof InterruptedException) {
                this.isStarted = false;
                return;
            }
            log.warn(e.getMessage(), e);
        }
        if (this.delayMillis < 0L) {
            this.delayMillis = 100L;
        }
        RunUtil.delay(this::run, (long)this.delayMillis);
    }

    private void runAsCron() throws Throwable {
        if (this.nextTime == null) {
            this.nextTime = this.cron.getNextValidTimeAfter(new Date());
        }
        if (this.nextTime != null) {
            this.delayMillis = this.nextTime.getTime() - System.currentTimeMillis();
            if (this.delayMillis <= 0L) {
                this.jobFutureOfCron = RunUtil.async(this::exec0);
                this.nextTime = this.cron.getNextValidTimeAfter(this.nextTime);
                if (this.nextTime != null) {
                    this.delayMillis = this.nextTime.getTime() - System.currentTimeMillis();
                }
            }
        }
        if (this.nextTime == null) {
            this.isStarted = false;
            log.warn("The cron expression has expired, and the job is complete!");
        }
    }

    private void exec0() {
        try {
            this.runnable.run();
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }
}

