/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.local.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.solon.Utils;
import org.noear.solon.cloud.exception.CloudFileException;
import org.noear.solon.cloud.model.Media;
import org.noear.solon.cloud.service.CloudFileService;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.util.IoUtil;

public class CloudFileServiceLocalImpl
implements CloudFileService {
    private File root;
    private final ReentrantLock SYNC_LOCK = new ReentrantLock();

    public CloudFileServiceLocalImpl(String rootDir) {
        this.root = new File(rootDir, "file");
        if (!this.root.exists()) {
            this.root.mkdirs();
        }
    }

    public boolean exists(String bucket, String key) throws CloudFileException {
        try {
            return this.getFile(bucket, key).exists();
        }
        catch (Throwable e) {
            throw new CloudFileException(e);
        }
    }

    public String getTempUrl(String bucket, String key, Duration duration) throws CloudFileException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Media get(String bucket, String key) throws CloudFileException {
        try {
            File file = this.getFile(bucket, key);
            if (file.exists()) {
                String contentType = Utils.mime((String)file.getName());
                return new Media((InputStream)new FileInputStream(file), contentType);
            }
            return null;
        }
        catch (Throwable e) {
            throw new CloudFileException(e);
        }
    }

    public Result put(String bucket, String key, Media media) throws CloudFileException {
        try {
            File file = this.getFile(bucket, key);
            if (!file.exists()) {
                file.createNewFile();
            }
            try (FileOutputStream stream = new FileOutputStream(file, false);){
                IoUtil.transferTo((InputStream)media.body(), (OutputStream)stream);
            }
            return Result.succeed((Object)file.getAbsolutePath());
        }
        catch (Throwable e) {
            throw new CloudFileException(e);
        }
    }

    public Result delete(String bucket, String key) throws CloudFileException {
        try {
            File file = this.getFile(bucket, key);
            if (file.exists() && !file.delete()) {
                return Result.failure();
            }
            return Result.succeed((Object)file.getAbsolutePath());
        }
        catch (Throwable e) {
            throw new CloudFileException(e);
        }
    }

    public Result deleteBatch(String bucket, Collection<String> keys) throws CloudFileException {
        for (String key : keys) {
            try {
                File file = this.getFile(bucket, key);
                if (!file.exists() || file.delete()) continue;
                return Result.failure();
            }
            catch (Throwable e) {
                throw new CloudFileException(e);
            }
        }
        return Result.succeed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFile(String bucket, String key) {
        if (Utils.isEmpty((String)bucket)) {
            bucket = "DEFAULT_BUCKET";
        }
        File dir = new File(this.root, bucket);
        this.SYNC_LOCK.lock();
        try {
            String dir2Str;
            File dir2Tmp;
            int last;
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if ((last = key.lastIndexOf(File.separator)) > 0 && !(dir2Tmp = new File(dir, dir2Str = key.substring(0, last))).exists()) {
                dir2Tmp.mkdirs();
            }
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
        File file = new File(dir, key);
        return file;
    }
}

