/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.local.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudDiscoveryHandler;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudDiscoveryObserverEntity;
import org.noear.solon.cloud.service.CloudDiscoveryService;

public class CloudDiscoveryServiceLocalImpl
implements CloudDiscoveryService {
    private Map<String, Discovery> serviceMap = new HashMap<String, Discovery>();
    private List<CloudDiscoveryObserverEntity> observerList = new ArrayList<CloudDiscoveryObserverEntity>();

    public void register(String group, Instance instance) {
        Discovery discovery;
        if (!Solon.cfg().appEnabled()) {
            return;
        }
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        if ((discovery = this.serviceMap.get(instance.service())) == null) {
            discovery = new Discovery(group, instance.service());
            this.serviceMap.put(instance.service(), discovery);
        }
        discovery.instanceAdd(instance);
        this.onRegister(discovery);
    }

    public void registerState(String group, Instance instance, boolean health) {
    }

    public void deregister(String group, Instance instance) {
    }

    public Discovery find(String group, String service) {
        Discovery tmp = this.serviceMap.get(service);
        if (tmp == null) {
            tmp = new Discovery(group, service);
        }
        return tmp;
    }

    public Collection<String> findServices(String group) {
        return this.serviceMap.keySet();
    }

    public void attention(String group, String service, CloudDiscoveryHandler observer) {
        this.observerList.add(new CloudDiscoveryObserverEntity(group, service, observer));
    }

    private void onRegister(Discovery discovery) {
        if (this.serviceMap.containsKey(discovery.service())) {
            for (CloudDiscoveryObserverEntity entity : this.observerList) {
                if (!discovery.service().equals(entity.service)) continue;
                entity.handle(discovery);
            }
        }
    }
}

