/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.solon.integration;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.solon.SolonConfigurator;
import java.net.URL;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.logging.LogOptions;
import org.noear.solon.logging.model.LoggerLevelEntity;
import org.slf4j.LoggerFactory;

public class XPluginImp
implements Plugin {
    public void init(AopContext context) throws Throwable {
        URL url = Utils.getResource((String)"logback.xml");
        if (url == null) {
            if (Utils.isNotEmpty((String)Solon.cfg().env())) {
                url = Utils.getResource((String)("logback-solon-" + Solon.cfg().env() + ".xml"));
            }
            if (url == null) {
                url = Utils.getResource((String)"logback-solon.xml");
            }
            if (url == null) {
                url = Utils.getResource((String)"META-INF/solon/logging/logback-def.xml");
            }
            if (url == null) {
                return;
            }
            this.initDo(url);
        }
    }

    public void start(AopContext context) throws Throwable {
        this.init(context);
    }

    private void initDo(URL url) {
        try {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            SolonConfigurator jc = new SolonConfigurator();
            jc.setContext((Context)loggerContext);
            loggerContext.reset();
            jc.doConfigure(url);
            if (LogOptions.getLoggerLevels().size() > 0) {
                for (LoggerLevelEntity lle : LogOptions.getLoggerLevels()) {
                    Logger logger = loggerContext.getLogger(lle.getLoggerExpr());
                    logger.setLevel(Level.valueOf((String)lle.getLevel().name()));
                }
            }
        }
        catch (JoranException e) {
            throw new IllegalStateException(e);
        }
    }
}

