/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.solon.integration;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.solon.SolonConfigurator;
import java.net.URL;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.core.Plugin;
import org.noear.solon.logging.LogOptions;
import org.noear.solon.logging.model.LoggerLevelEntity;
import org.slf4j.LoggerFactory;

public class XPluginImp
implements Plugin {
    public void start(SolonApp app) {
        URL url = Utils.getResource((String)"logback.xml");
        if (url == null) {
            if (Utils.isNotEmpty((String)Solon.cfg().env())) {
                url = Utils.getResource((String)("logback-solon-" + Solon.cfg().env() + ".xml"));
            }
            if (url == null) {
                url = Utils.getResource((String)"logback-solon.xml");
            }
            if (url == null) {
                url = Utils.getResource((String)"META-INF/solon/logging/logback-def.xml");
            }
            if (url == null) {
                return;
            }
            this.initDo(url);
        }
    }

    private void initDo(URL url) {
        try {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            SolonConfigurator jc = new SolonConfigurator();
            jc.setContext((Context)loggerContext);
            loggerContext.reset();
            jc.doConfigure(url);
            if (LogOptions.getLoggerLevels().size() > 0) {
                for (LoggerLevelEntity lle : LogOptions.getLoggerLevels()) {
                    loggerContext.getLogger(lle.getLoggerExpr()).setLevel(Level.valueOf((String)lle.getLevel().name()));
                }
            }
        }
        catch (JoranException e) {
            throw new RuntimeException(e);
        }
    }
}

