/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.luffy.impl;

import java.util.Map;
import org.noear.luffy.executor.IJtConfigAdapter;
import org.noear.luffy.executor.IJtExecutorAdapter;
import org.noear.luffy.model.AFileModel;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.extend.luffy.impl.JtMapping;
import org.noear.solon.extend.luffy.impl.JtResouceLoader;
import org.noear.solon.extend.luffy.impl.JtResouceLoaderClass;
import org.noear.solon.extend.luffy.impl.JtResouceLoaderFile;
import org.noear.solon.logging.utils.TagsMDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtExecutorAdapter
implements IJtExecutorAdapter,
IJtConfigAdapter {
    static Logger log = LoggerFactory.getLogger(JtExecutorAdapter.class);
    private String _defaultExecutor;
    private String _defLogTag = "luffy";
    JtResouceLoader forDebug = new JtResouceLoaderFile();
    JtResouceLoader forRelease = new JtResouceLoaderClass();
    private String _nodeId;

    public JtExecutorAdapter() {
        this._defaultExecutor = JtMapping.getActuator("");
    }

    public void log(AFileModel file, Map<String, Object> data) {
        Context ctx;
        if (file == null && (ctx = Context.current()) != null) {
            file = (AFileModel)ctx.attr("file");
        }
        if (!data.containsKey("tag")) {
            TagsMDC.tag0((String)this._defLogTag);
        }
        if (file != null && !data.containsKey("tag2")) {
            TagsMDC.tag2((String)file.path);
        }
        log.debug("{}", data);
    }

    public void logError(AFileModel file, String msg, Throwable err) {
        TagsMDC.tag0((String)this._defLogTag);
        TagsMDC.tag2((String)file.path);
        if (err == null) {
            log.error("{}", (Object)msg);
        } else {
            log.error("{}\r\n{}", (Object)msg, (Object)err);
        }
    }

    public AFileModel fileGet(String path) throws Exception {
        AFileModel file = null;
        if (Solon.cfg().isDebugMode()) {
            file = this.forDebug.fileGet(path);
        }
        if (file == null) {
            this.forRelease.fileGet(path);
        }
        return file;
    }

    public String nodeId() {
        if (this._nodeId == null) {
            this._nodeId = Utils.guid();
        }
        return this._nodeId;
    }

    public String defaultExecutor() {
        return this._defaultExecutor;
    }

    public void defaultExecutorSet(String defaultExecutor) {
        this._defaultExecutor = defaultExecutor;
    }

    public String cfgGet(String name, String def) throws Exception {
        if (Utils.isEmpty((String)name)) {
            return def;
        }
        return Solon.cfg().get(name, def);
    }

    public boolean cfgSet(String name, String value) throws Exception {
        if (Utils.isEmpty((String)name)) {
            return false;
        }
        Solon.cfg().setProperty(name, value);
        return true;
    }
}

