/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.regex.Pattern;

public class HtmlRendererOptions {
    public final String softBreak;
    public final boolean isSoftBreakAllSpaces;
    public final String hardBreak;
    public final String strongEmphasisStyleHtmlOpen;
    public final String strongEmphasisStyleHtmlClose;
    public final String emphasisStyleHtmlOpen;
    public final String emphasisStyleHtmlClose;
    public final String codeStyleHtmlOpen;
    public final String codeStyleHtmlClose;
    public final boolean escapeHtmlBlocks;
    public final boolean escapeHtmlCommentBlocks;
    public final boolean escapeInlineHtml;
    public final boolean escapeInlineHtmlComments;
    public final boolean percentEncodeUrls;
    public final int indentSize;
    public final boolean suppressHtmlBlocks;
    public final boolean suppressHtmlCommentBlocks;
    public final boolean suppressInlineHtml;
    public final boolean suppressInlineHtmlComments;
    public final boolean doNotRenderLinksInDocument;
    public final boolean renderHeaderId;
    public final boolean generateHeaderIds;
    public final String languageClassPrefix;
    public final String noLanguageClass;
    public final String sourcePositionAttribute;
    public final String inlineCodeSpliceClass;
    public final boolean sourcePositionParagraphLines;
    public final boolean sourceWrapHtmlBlocks;
    public final int formatFlags;
    public final int maxTrailingBlankLines;
    public final boolean htmlBlockOpenTagEol;
    public final boolean htmlBlockCloseTagEol;
    public final boolean unescapeHtmlEntities;
    public final String autolinkWwwPrefix;
    public final Pattern suppressedLinks;

    public HtmlRendererOptions(DataHolder options) {
        this.softBreak = HtmlRenderer.SOFT_BREAK.getFrom(options);
        this.isSoftBreakAllSpaces = Utils.isWhiteSpaceNoEOL(this.softBreak);
        this.hardBreak = HtmlRenderer.HARD_BREAK.getFrom(options);
        this.strongEmphasisStyleHtmlOpen = HtmlRenderer.STRONG_EMPHASIS_STYLE_HTML_OPEN.getFrom(options);
        this.strongEmphasisStyleHtmlClose = HtmlRenderer.STRONG_EMPHASIS_STYLE_HTML_CLOSE.getFrom(options);
        this.emphasisStyleHtmlOpen = HtmlRenderer.EMPHASIS_STYLE_HTML_OPEN.getFrom(options);
        this.emphasisStyleHtmlClose = HtmlRenderer.EMPHASIS_STYLE_HTML_CLOSE.getFrom(options);
        this.codeStyleHtmlOpen = HtmlRenderer.CODE_STYLE_HTML_OPEN.getFrom(options);
        this.codeStyleHtmlClose = HtmlRenderer.CODE_STYLE_HTML_CLOSE.getFrom(options);
        this.escapeHtmlBlocks = HtmlRenderer.ESCAPE_HTML_BLOCKS.getFrom(options);
        this.escapeHtmlCommentBlocks = HtmlRenderer.ESCAPE_HTML_COMMENT_BLOCKS.getFrom(options);
        this.escapeInlineHtml = HtmlRenderer.ESCAPE_INLINE_HTML.getFrom(options);
        this.escapeInlineHtmlComments = HtmlRenderer.ESCAPE_INLINE_HTML_COMMENTS.getFrom(options);
        this.percentEncodeUrls = HtmlRenderer.PERCENT_ENCODE_URLS.getFrom(options);
        this.indentSize = HtmlRenderer.INDENT_SIZE.getFrom(options);
        this.suppressHtmlBlocks = HtmlRenderer.SUPPRESS_HTML_BLOCKS.getFrom(options);
        this.suppressHtmlCommentBlocks = HtmlRenderer.SUPPRESS_HTML_COMMENT_BLOCKS.getFrom(options);
        this.suppressInlineHtml = HtmlRenderer.SUPPRESS_INLINE_HTML.getFrom(options);
        this.suppressInlineHtmlComments = HtmlRenderer.SUPPRESS_INLINE_HTML_COMMENTS.getFrom(options);
        this.doNotRenderLinksInDocument = HtmlRenderer.DO_NOT_RENDER_LINKS.getFrom(options);
        this.renderHeaderId = HtmlRenderer.RENDER_HEADER_ID.getFrom(options);
        this.generateHeaderIds = HtmlRenderer.GENERATE_HEADER_ID.getFrom(options);
        this.languageClassPrefix = HtmlRenderer.FENCED_CODE_LANGUAGE_CLASS_PREFIX.getFrom(options);
        this.noLanguageClass = HtmlRenderer.FENCED_CODE_NO_LANGUAGE_CLASS.getFrom(options);
        this.sourcePositionAttribute = HtmlRenderer.SOURCE_POSITION_ATTRIBUTE.getFrom(options);
        this.sourcePositionParagraphLines = !this.sourcePositionAttribute.isEmpty() && HtmlRenderer.SOURCE_POSITION_PARAGRAPH_LINES.getFrom(options) != false;
        this.sourceWrapHtmlBlocks = !this.sourcePositionAttribute.isEmpty() && HtmlRenderer.SOURCE_WRAP_HTML_BLOCKS.getFrom(options) != false;
        this.formatFlags = HtmlRenderer.FORMAT_FLAGS.getFrom(options);
        this.maxTrailingBlankLines = HtmlRenderer.MAX_TRAILING_BLANK_LINES.getFrom(options);
        this.htmlBlockOpenTagEol = HtmlRenderer.HTML_BLOCK_OPEN_TAG_EOL.getFrom(options);
        this.htmlBlockCloseTagEol = HtmlRenderer.HTML_BLOCK_CLOSE_TAG_EOL.getFrom(options);
        this.unescapeHtmlEntities = HtmlRenderer.UNESCAPE_HTML_ENTITIES.getFrom(options);
        this.inlineCodeSpliceClass = HtmlRenderer.INLINE_CODE_SPLICE_CLASS.getFrom(options);
        this.autolinkWwwPrefix = HtmlRenderer.AUTOLINK_WWW_PREFIX.getFrom(options);
        String ignoreLinks = HtmlRenderer.SUPPRESSED_LINKS.getFrom(options);
        this.suppressedLinks = ignoreLinks.isEmpty() ? null : Pattern.compile(ignoreLinks);
    }
}

