/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import com.vladsch.flexmark.util.Computable;

public class CopyOnWriteRef<T> {
    private T myValue;
    private int myReferenceCount;
    private Computable<T, T> myCloner;
    private boolean myMutable;

    public CopyOnWriteRef(T value, Computable<T, T> cloner) {
        this.myValue = value;
        this.myReferenceCount = 0;
        this.myCloner = cloner;
    }

    public T getPeek() {
        return this.myValue;
    }

    public T getImmutable() {
        if (this.myValue != null) {
            ++this.myReferenceCount;
        }
        return this.myValue;
    }

    public T getMutable() {
        if (this.myReferenceCount > 0) {
            this.myValue = this.myCloner.compute(this.myValue);
            this.myReferenceCount = 0;
        }
        return this.myValue;
    }

    public void setValue(T value) {
        this.myReferenceCount = 0;
        this.myValue = this.myCloner.compute(value);
    }

    public boolean isMutable() {
        return this.myReferenceCount == 0;
    }
}

