/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.data;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSetter;

public class MutableDataSet
extends DataSet
implements MutableDataHolder {
    public MutableDataSet() {
    }

    public MutableDataSet(DataHolder other) {
        super(other);
    }

    @Override
    public <T> MutableDataSet set(DataKey<? extends T> key, T value) {
        this.dataSet.put(key, value);
        return this;
    }

    @Override
    public MutableDataHolder setFrom(MutableDataSetter dataSetter) {
        return dataSetter.setIn(this);
    }

    @Override
    public MutableDataSet setAll(DataHolder other) {
        for (DataKey<?> key : other.getKeys()) {
            this.set(key, other.get(key));
        }
        return this;
    }

    @Override
    public MutableDataHolder setIn(MutableDataHolder dataHolder) {
        dataHolder.setAll(this);
        return dataHolder;
    }

    @Override
    public <T> T get(DataKey<T> key) {
        return this.getOrCompute(key);
    }

    @Override
    public <T> MutableDataSet remove(DataKey<T> key) {
        this.dataSet.remove(key);
        return this;
    }

    @Override
    public <T> T getOrCompute(DataKey<T> key) {
        if (this.dataSet.containsKey(key)) {
            return (T)this.dataSet.get(key);
        }
        T newValue = key.getDefaultValue(this);
        this.dataSet.put(key, newValue);
        return newValue;
    }

    public static MutableDataSet merge(DataHolder ... dataHolders) {
        MutableDataSet dataSet = new MutableDataSet();
        for (DataHolder dataHolder : dataHolders) {
            if (dataHolder == null) continue;
            dataSet.dataSet.putAll(dataHolder.getAll());
        }
        return dataSet;
    }

    @Override
    public MutableDataSet toMutable() {
        return this;
    }

    @Override
    public DataHolder toImmutable() {
        return new DataSet(this);
    }

    @Override
    public MutableDataHolder clear() {
        this.dataSet.clear();
        return this;
    }
}

