/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.DoNotDecorate;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;

public class FencedCodeBlock
extends Block
implements DoNotDecorate {
    private int fenceIndent;
    private BasedSequence openingMarker = BasedSequence.NULL;
    private BasedSequence info = BasedSequence.NULL;
    private BasedSequence attributes = BasedSequence.NULL;
    private BasedSequence closingMarker = BasedSequence.NULL;

    @Override
    public void getAstExtra(StringBuilder out) {
        BasedSequence content = this.getContentChars();
        int lines = this.getContentLines().size();
        FencedCodeBlock.segmentSpanChars(out, this.openingMarker, "open");
        FencedCodeBlock.segmentSpanChars(out, this.info, "info");
        FencedCodeBlock.segmentSpanChars(out, this.attributes, "attributes");
        FencedCodeBlock.segmentSpan(out, content, "content");
        out.append(" lines[").append(lines).append("]");
        FencedCodeBlock.segmentSpanChars(out, this.closingMarker, "close");
    }

    @Override
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.info, this.attributes, this.getContentChars(), this.closingMarker};
    }

    public FencedCodeBlock() {
    }

    public FencedCodeBlock(BasedSequence chars) {
        super(chars);
    }

    public FencedCodeBlock(BasedSequence chars, BasedSequence openingMarker, BasedSequence info, List<BasedSequence> segments, BasedSequence closingMarker) {
        super(chars, segments);
        this.openingMarker = openingMarker;
        this.info = info;
        this.closingMarker = closingMarker;
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public void setInfo(BasedSequence info) {
        this.info = info;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }

    public BasedSequence getOpeningFence() {
        return this.openingMarker;
    }

    public BasedSequence getInfo() {
        return this.info;
    }

    public BasedSequence getAttributes() {
        return this.attributes;
    }

    public void setAttributes(BasedSequence attributes) {
        this.attributes = attributes;
    }

    public BasedSequence getInfoDelimitedByAny(CharSequence delimiters) {
        BasedSequence language = BasedSequence.NULL;
        if (this.info.isNotNull() && !this.info.isBlank()) {
            int space = this.info.indexOfAny(delimiters);
            language = space == -1 ? this.info : (BasedSequence)this.info.subSequence(0, space);
        }
        return language;
    }

    public BasedSequence getClosingFence() {
        return this.closingMarker;
    }

    public int getFenceLength() {
        return this.getInfo().length();
    }

    public int getFenceIndent() {
        return this.fenceIndent;
    }

    public void setFenceIndent(int fenceIndent) {
        this.fenceIndent = fenceIndent;
    }
}

