/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.recognition.ns;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.algorithm.Viterbi;
import com.hankcs.hanlp.corpus.dictionary.item.EnumItem;
import com.hankcs.hanlp.corpus.tag.NS;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.ns.PlaceDictionary;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class PlaceRecognition {
    public static boolean recognition(List<Vertex> pWordSegResult, WordNet wordNetOptimum, WordNet wordNetAll) {
        List<EnumItem<NS>> roleTagList = PlaceRecognition.roleTag(pWordSegResult, wordNetAll);
        if (HanLP.Config.DEBUG) {
            StringBuilder sbLog = new StringBuilder();
            Iterator<Vertex> iterator = pWordSegResult.iterator();
            for (EnumItem<NS> NSEnumItem : roleTagList) {
                sbLog.append('[');
                sbLog.append(iterator.next().realWord);
                sbLog.append(' ');
                sbLog.append(NSEnumItem);
                sbLog.append(']');
            }
            System.out.printf("\u5730\u540d\u89d2\u8272\u89c2\u5bdf\uff1a%s\n", sbLog.toString());
        }
        List<NS> NSList = PlaceRecognition.viterbiCompute(roleTagList);
        if (HanLP.Config.DEBUG) {
            StringBuilder sbLog = new StringBuilder();
            Iterator<Vertex> iterator = pWordSegResult.iterator();
            sbLog.append('[');
            for (NS NS2 : NSList) {
                sbLog.append(iterator.next().realWord);
                sbLog.append('/');
                sbLog.append((Object)NS2);
                sbLog.append(" ,");
            }
            if (sbLog.length() > 1) {
                sbLog.delete(sbLog.length() - 2, sbLog.length());
            }
            sbLog.append(']');
            System.out.printf("\u5730\u540d\u89d2\u8272\u6807\u6ce8\uff1a%s\n", sbLog.toString());
        }
        PlaceDictionary.parsePattern(NSList, pWordSegResult, wordNetOptimum, wordNetAll);
        return true;
    }

    public static List<EnumItem<NS>> roleTag(List<Vertex> vertexList, WordNet wordNetAll) {
        LinkedList<EnumItem<NS>> tagList = new LinkedList<EnumItem<NS>>();
        ListIterator<Vertex> listIterator = vertexList.listIterator();
        while (listIterator.hasNext()) {
            Vertex vertex = listIterator.next();
            if (Nature.ns == vertex.getNature() && vertex.getAttribute().totalFrequency <= 1000) {
                if (vertex.realWord.length() < 3) {
                    tagList.add(new EnumItem((Enum[])new NS[]{NS.H, NS.G}));
                    continue;
                }
                tagList.add(new EnumItem((Enum[])new NS[]{NS.G}));
                continue;
            }
            EnumItem<NS> NSEnumItem = (EnumItem<NS>)PlaceDictionary.dictionary.get(vertex.word);
            if (NSEnumItem == null) {
                NSEnumItem = new EnumItem<NS>(NS.Z, PlaceDictionary.transformMatrixDictionary.getTotalFrequency(NS.Z));
            }
            tagList.add(NSEnumItem);
        }
        return tagList;
    }

    public static List<NS> viterbiCompute(List<EnumItem<NS>> roleTagList) {
        return Viterbi.computeEnum(roleTagList, PlaceDictionary.transformMatrixDictionary);
    }
}

