/*
 * Decompiled with CFR 0.152.
 */
package org.noear.luffy.event.message.dso;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.noear.luffy.utils.TextUtils;

public class DisttimeUtil {
    public static int nextTime(int dist_count) {
        double temp = DisttimeUtil.getTimespan();
        switch (dist_count) {
            case 0: {
                temp = 0.0;
                break;
            }
            case 1: {
                temp += 30.0;
                break;
            }
            case 2: {
                temp += 120.0;
                break;
            }
            case 3: {
                temp += 300.0;
                break;
            }
            case 4: {
                temp += 600.0;
                break;
            }
            case 5: {
                temp += 1800.0;
                break;
            }
            case 6: {
                temp += 3600.0;
                break;
            }
            case 7: {
                temp += 5400.0;
                break;
            }
            default: {
                temp += 7200.0;
            }
        }
        return (int)(temp / 10.0);
    }

    public static int nextTime(Date date) {
        return (int)(DisttimeUtil.getTimespan(date) / 10.0);
    }

    public static int currTime() {
        return (int)(DisttimeUtil.getTimespan() / 10.0);
    }

    private static double getTimespan() {
        return (double)System.currentTimeMillis() / 1000.0 - 1.5E9;
    }

    private static double getTimespan(Date date) {
        return (double)date.getTime() / 1000.0 - 1.5E9;
    }

    public static Date getDate(String dateString, String format) {
        if (TextUtils.isEmpty((String)dateString)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            return df.parse(dateString);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

