/*
 * Decompiled with CFR 0.152.
 */
package org.noear.luffy.event.schedule.controller;

import java.util.Date;
import java.util.List;
import org.noear.luffy.dso.JtLock;
import org.noear.luffy.dso.LogLevel;
import org.noear.luffy.dso.LogUtil;
import org.noear.luffy.event.schedule.dso.DbApi;
import org.noear.luffy.executor.ExecutorFactory;
import org.noear.luffy.model.AFileModel;
import org.noear.luffy.task.JtTaskBase;
import org.noear.luffy.task.cron.CronUtils;
import org.noear.luffy.utils.Datetime;
import org.noear.luffy.utils.ExceptionUtils;
import org.noear.luffy.utils.Timecount;
import org.noear.luffy.utils.Timespan;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.handle.ContextUtil;

public class ScheduleTask
extends JtTaskBase {
    private boolean _init = false;

    public ScheduleTask() {
        super("_schedule", 1000);
    }

    public void exec() throws Exception {
        if (!this.node_current_can_run()) {
            return;
        }
        this._interval = this._interval_bak;
        if (!this._init) {
            this._init = true;
            DbApi.taskResetState();
        }
        List<AFileModel> list = DbApi.taskGetList();
        for (AFileModel task : list) {
            if (!JtLock.g.tryLock("luffy.event", this.getName() + "_" + task.file_id)) continue;
            this.poolExecute(() -> this.doExec(task));
        }
    }

    private void doExec(AFileModel task) {
        try {
            this.runTask(task);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            try {
                String err = ExceptionUtils.getString((Throwable)ex);
                LogUtil.log((String)this.getName(), (String)task.tag, (String)task.path, (LogLevel)LogLevel.ERROR, (String)"", (String)err);
            }
            catch (Throwable ee) {
                ee.printStackTrace();
            }
            try {
                DbApi.taskSetState(task, 8);
            }
            catch (Throwable ee) {
                ee.printStackTrace();
            }
        }
    }

    private void runTask(AFileModel task) throws Exception {
        if (task == null || task.file_id == 0) {
            return;
        }
        if (task.plan_max > 0 && task.plan_count >= task.plan_max) {
            return;
        }
        if (task.plan_interval == null || task.plan_interval.length() < 2) {
            return;
        }
        if (task.plan_state == 2) {
            return;
        }
        Date temp = task.plan_last_time;
        if (temp == null) {
            temp = task.plan_begin_time;
        }
        if (temp == null) {
            return;
        }
        if (task.plan_interval.length() > 7 && task.plan_interval.contains(" ")) {
            Date next = CronUtils.getNextTime((String)task.plan_interval, (Date)temp);
            if (System.currentTimeMillis() > next.getTime()) {
                return;
            }
        } else {
            String s2;
            Datetime last_time = new Datetime(temp);
            String s1 = task.plan_interval.substring(0, task.plan_interval.length() - 1);
            switch (s2 = task.plan_interval.substring(task.plan_interval.length() - 1)) {
                case "m": {
                    last_time.addMinute(Integer.parseInt(s1));
                    break;
                }
                case "h": {
                    last_time.addHour(Integer.parseInt(s1));
                    break;
                }
                case "d": {
                    task._is_day_task = true;
                    last_time.addDay(Integer.parseInt(s1));
                    break;
                }
                case "M": {
                    task._is_day_task = true;
                    last_time.addMonth(Integer.parseInt(s1));
                    break;
                }
                default: {
                    last_time.addDay(1);
                }
            }
            if (new Timespan(last_time.getFulltime()).seconds() < 0L) {
                return;
            }
        }
        this.do_runTask(task);
    }

    private void do_runTask(AFileModel task) throws Exception {
        Timecount timecount = new Timecount().start();
        task.plan_last_time = new Date();
        DbApi.taskSetState(task, 2);
        Context ctx = ContextEmpty.create();
        ContextUtil.currentSet((Context)ctx);
        ExecutorFactory.execOnly((AFileModel)task, (Context)ctx);
        ContextUtil.currentRemove();
        ++task.plan_count;
        task.plan_last_timespan = timecount.stop().milliseconds();
        DbApi.taskSetState(task, 9);
        LogUtil.log((String)this.getName(), (String)task.tag, (String)task.path, (String)(task.file_id + ""), (LogLevel)LogLevel.TRACE, (String)"", (String)"\u6267\u884c\u6210\u529f");
    }
}

