/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.cache;

import org.jetbrains.annotations.NotNull;

public class ContextBuffer {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final float RESIZE_FACTOR = 1.2f;
    private static final int DEFAULT_SIZE = 256;
    int maxSize;
    boolean inner = true;
    private char[] charBuffer = new char[256];
    private byte[] byteBuffer = new byte[256];

    public ContextBuffer(int maxSize, boolean inner) {
        this(maxSize);
        this.inner = inner;
    }

    public ContextBuffer(int maxSize) {
        if (maxSize < 256) {
            throw new IllegalArgumentException("buffer\u671f\u671b\u8bbe\u7f6e\u9700\u8981\u5927\u4e8e 256");
        }
        this.maxSize = maxSize;
    }

    @NotNull
    public char[] getCharBuffer() {
        return this.charBuffer;
    }

    @NotNull
    public byte[] getByteBuffer() {
        return this.byteBuffer;
    }

    @NotNull
    public char[] getCharBuffer(int expected) {
        if (this.charBuffer.length >= expected) {
            return this.charBuffer;
        }
        if (expected < this.maxSize) {
            this.charBuffer = new char[(int)((float)expected * 1.2f)];
            return this.charBuffer;
        }
        return EMPTY_CHAR_ARRAY;
    }

    @NotNull
    public byte[] getByteBuffer(int expected) {
        if (this.byteBuffer.length >= expected) {
            return this.byteBuffer;
        }
        if (expected < this.maxSize) {
            this.byteBuffer = new byte[(int)((float)expected * 1.2f)];
            return this.byteBuffer;
        }
        return EMPTY_BYTE_ARRAY;
    }
}

